/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.localconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.springframework.cloud.localconfig.LocalConfigConnector;
import org.springframework.cloud.service.UriBasedServiceData;

public final class LocalConfigUtil {
    private static final Logger logger = Logger.getLogger(LocalConfigConnector.class.getName());

    private LocalConfigUtil() {
    }

    static List<UriBasedServiceData> readServicesData(LinkedHashMap<String, Properties> propertySources) {
        HashMap<String, String> collectedServices = new HashMap<String, String>();
        for (Map.Entry<String, Properties> propertySource : propertySources.entrySet()) {
            if (propertySource.getValue().isEmpty()) {
                logger.info("no " + propertySource.getKey());
                continue;
            }
            logger.info("reading services from " + propertySource.getKey());
            Map<String, String> services = LocalConfigUtil.readServices(propertySource.getValue());
            for (Map.Entry<String, String> service : services.entrySet()) {
                String oldUri = collectedServices.put(service.getKey(), service.getValue());
                if (oldUri == null) {
                    logger.info("added service '" + service.getKey() + "' from " + propertySource.getKey());
                    continue;
                }
                logger.warning("replaced service '" + service.getKey() + "' with new URI from " + propertySource.getKey());
            }
        }
        ArrayList<UriBasedServiceData> serviceData = new ArrayList<UriBasedServiceData>(collectedServices.size());
        for (Map.Entry serviceInfo : collectedServices.entrySet()) {
            serviceData.add(new UriBasedServiceData((String)serviceInfo.getKey(), (String)serviceInfo.getValue()));
        }
        return serviceData;
    }

    static Map<String, String> readServices(Properties properties) {
        HashMap<String, String> services = new HashMap<String, String>();
        for (String propertyName : properties.stringPropertyNames()) {
            if (LocalConfigConnector.META_PROPERTIES.contains(propertyName)) {
                logger.finer("skipping meta property " + propertyName);
                continue;
            }
            Matcher m = LocalConfigConnector.SERVICE_PROPERTY_PATTERN.matcher(propertyName);
            if (!m.matches()) {
                logger.finest("skipping non-Spring-Cloud property " + propertyName);
                continue;
            }
            String serviceId = m.group(1);
            String serviceUri = properties.getProperty(propertyName);
            logger.fine("found service URI for service " + serviceId);
            services.put(serviceId, serviceUri);
        }
        return services;
    }
}

