/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.SelectedInstanceCallback;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Flux;

public class SameInstancePreferenceServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier
implements SelectedInstanceCallback {
    private static final Log LOG = LogFactory.getLog(SameInstancePreferenceServiceInstanceListSupplier.class);
    private @Nullable ServiceInstance previouslyReturnedInstance;
    private boolean callGetWithRequestOnDelegates;

    public SameInstancePreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
        super(delegate);
    }

    public SameInstancePreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory) {
        super(delegate);
        LoadBalancerProperties properties = loadBalancerClientFactory.getProperties(this.getServiceId());
        this.callGetWithRequestOnDelegates = properties != null ? properties.isCallGetWithRequestOnDelegates() : true;
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return ((Flux)this.delegate.get()).map(this::filteredBySameInstancePreference);
    }

    @Override
    public Flux<List<ServiceInstance>> get(Request request) {
        if (this.callGetWithRequestOnDelegates) {
            return this.delegate.get(request).map(this::filteredBySameInstancePreference);
        }
        return this.get();
    }

    private List<ServiceInstance> filteredBySameInstancePreference(List<ServiceInstance> serviceInstances) {
        if (this.previouslyReturnedInstance != null && serviceInstances.contains(this.previouslyReturnedInstance)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Returning previously selected service instance: %s", this.previouslyReturnedInstance));
            }
            return Collections.singletonList(this.previouslyReturnedInstance);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Previously selected service instance %s was not available. Returning all the instances returned by delegate.", this.previouslyReturnedInstance));
        }
        this.previouslyReturnedInstance = null;
        return serviceInstances;
    }

    @Override
    public void selectedServiceInstance(ServiceInstance serviceInstance) {
        super.selectedServiceInstance(serviceInstance);
        if (this.previouslyReturnedInstance == null || !this.previouslyReturnedInstance.equals((Object)serviceInstance)) {
            this.previouslyReturnedInstance = serviceInstance;
        }
    }
}

