/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.blocking;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;

public class XForwardedHeadersTransformer
implements LoadBalancerRequestTransformer {
    private final ReactiveLoadBalancer.Factory<ServiceInstance> factory;

    public XForwardedHeadersTransformer(ReactiveLoadBalancer.Factory<ServiceInstance> factory) {
        this.factory = factory;
    }

    public HttpRequest transformRequest(HttpRequest request, ServiceInstance instance) {
        if (instance == null) {
            return request;
        }
        LoadBalancerProperties.XForwarded xForwarded = this.factory.getProperties(instance.getServiceId()).getXForwarded();
        if (xForwarded.isEnabled()) {
            HttpHeaders headers = request.getHeaders();
            String xForwardedHost = request.getURI().getHost();
            String xforwardedProto = request.getURI().getScheme();
            headers.add("X-Forwarded-Host", xForwardedHost);
            headers.add("X-Forwarded-Proto", xforwardedProto);
        }
        return request;
    }
}

