/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons.native_client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.ApiregistrationV1Api;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.RbacAuthorizationV1Api;
import io.kubernetes.client.openapi.models.V1ClusterRole;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentCondition;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1NamespaceBuilder;
import io.kubernetes.client.openapi.models.V1NamespaceFluent;
import io.kubernetes.client.openapi.models.V1Role;
import io.kubernetes.client.openapi.models.V1RoleBinding;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Yaml;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.springframework.cloud.kubernetes.integration.tests.commons.Commons;
import org.springframework.cloud.kubernetes.integration.tests.commons.Images;
import org.springframework.cloud.kubernetes.integration.tests.commons.Phase;
import org.testcontainers.k3s.K3sContainer;

public final class Util {
    private static final Log LOG = LogFactory.getLog(Util.class);
    private final CoreV1Api coreV1Api;
    private final AppsV1Api appsV1Api;
    private final RbacAuthorizationV1Api rbacApi;
    private final K3sContainer container;

    public Util(K3sContainer container) {
        ApiClient client;
        try {
            client = Config.fromConfig((Reader)new StringReader(container.getKubeConfigYaml()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        client.setHttpClient(client.getHttpClient().newBuilder().readTimeout(Duration.ofSeconds(15L)).build());
        client.setDebugging(false);
        Configuration.setDefaultApiClient((ApiClient)client);
        this.container = container;
        this.coreV1Api = new CoreV1Api();
        this.appsV1Api = new AppsV1Api();
        this.rbacApi = new RbacAuthorizationV1Api();
    }

    public void createAndWait(String namespace, String name, V1Deployment deployment, V1Service service, boolean changeVersion) {
        try {
            this.coreV1Api.createNamespacedService(namespace, service).execute();
            if (deployment != null) {
                String imageFromDeployment = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
                if (changeVersion) {
                    ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageFromDeployment + ":" + Commons.pomVersion());
                } else {
                    String[] image = imageFromDeployment.split(":", 2);
                    Commons.pullImage(image[0], image[1], name, this.container);
                    Commons.loadImage(image[0], image[1], name, this.container);
                }
                this.appsV1Api.createNamespacedDeployment(namespace, deployment).execute();
                this.waitForDeployment(namespace, deployment);
            }
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                ApiException apiException = (ApiException)((Object)e);
                System.out.println(apiException.getResponseBody());
            }
            throw new RuntimeException(e);
        }
    }

    public void createAndWait(String namespace, @Nullable V1ConfigMap configMap, @Nullable V1Secret secret) {
        try {
            if (configMap != null) {
                this.coreV1Api.createNamespacedConfigMap(namespace, configMap).execute();
                this.waitForConfigMap(namespace, configMap, Phase.CREATE);
            }
            if (secret != null) {
                this.coreV1Api.createNamespacedSecret(namespace, secret).execute();
                this.waitForSecret(namespace, secret, Phase.CREATE);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAndWait(String namespace, @Nullable V1ConfigMap configMap, @Nullable V1Secret secret) {
        try {
            if (configMap != null) {
                String configMapName = this.configMapName(configMap);
                this.coreV1Api.deleteNamespacedConfigMap(configMapName, namespace).execute();
                this.waitForConfigMap(namespace, configMap, Phase.DELETE);
            }
            if (secret != null) {
                String secretName = this.secretName(secret);
                this.coreV1Api.deleteNamespacedSecret(secretName, namespace).execute();
                this.waitForSecret(namespace, secret, Phase.DELETE);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createNamespace(String name) {
        try {
            this.coreV1Api.createNamespace(((V1NamespaceBuilder)((V1NamespaceFluent.MetadataNested)new V1NamespaceBuilder().withNewMetadata().withName(name)).and()).build()).execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAndWait(String namespace, V1Deployment deployment, V1Service service) {
        try {
            if (deployment != null) {
                String deploymentName = this.deploymentName(deployment);
                Map podLabels = this.appsV1Api.readNamespacedDeployment(deploymentName, namespace).execute().getSpec().getTemplate().getMetadata().getLabels();
                this.appsV1Api.deleteNamespacedDeployment(deploymentName, namespace).execute();
                this.coreV1Api.deleteCollectionNamespacedPod(namespace).labelSelector(Util.labelSelector(podLabels)).execute();
                this.waitForDeploymentToBeDeleted(deploymentName, namespace);
                this.waitForDeploymentPodsToBeDeleted(podLabels, namespace);
            }
            if (service != null) {
                service.getMetadata().setNamespace(namespace);
                this.coreV1Api.deleteNamespacedService(service.getMetadata().getName(), service.getMetadata().getNamespace()).execute();
                this.waitForServiceToBeDeleted(service.getMetadata().getName(), namespace);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void busybox(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("busybox/deployment.yaml");
        String imageWithoutVersion = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.busyboxVersion();
        ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        V1Service service = (V1Service)this.yaml("busybox/service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "busybox", deployment, service, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service);
        }
    }

    public void kafka(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("kafka/kafka-deployment.yaml");
        String imageWithoutVersion = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.kafkaVersion();
        ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        V1Service service = (V1Service)this.yaml("kafka/kafka-service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "kafka", deployment, service, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service);
        }
    }

    public void rabbitMq(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("rabbitmq/rabbitmq-deployment.yaml");
        String imageWithoutVersion = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.rabbitMqVersion();
        ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        V1Service service = (V1Service)this.yaml("rabbitmq/rabbitmq-service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "rabbitmq", deployment, service, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service);
        }
    }

    public Object yaml(String fileName) {
        ClassLoader classLoader = Util.class.getClassLoader();
        String file = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(fileName))).lines().collect(Collectors.joining("\n"));
        try {
            return Yaml.load((String)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUp(String namespace) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("setup/service-account.yaml");
            CheckedSupplier<V1ServiceAccount> accountSupplier = () -> this.coreV1Api.readNamespacedServiceAccount(serviceAccount.getMetadata().getName(), namespace).execute();
            CheckedSupplier<V1ServiceAccount> accountDefaulter = () -> this.coreV1Api.createNamespacedServiceAccount(namespace, serviceAccount).execute();
            Util.notExistsHandler(accountSupplier, accountDefaulter);
            V1RoleBinding roleBinding = (V1RoleBinding)this.yaml("setup/role-binding.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace).execute(), () -> this.rbacApi.createNamespacedRoleBinding(namespace, roleBinding).execute());
            V1Role role = (V1Role)this.yaml("setup/role.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readNamespacedRole(role.getMetadata().getName(), namespace).execute(), () -> this.rbacApi.createNamespacedRole(namespace, role).execute());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setUpClusterWide(String serviceAccountNamespace, Set<String> namespaces) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("cluster/service-account.yaml");
            CheckedSupplier<V1ServiceAccount> accountSupplier = () -> this.coreV1Api.readNamespacedServiceAccount(serviceAccount.getMetadata().getName(), serviceAccountNamespace).execute();
            CheckedSupplier<V1ServiceAccount> accountDefaulter = () -> this.coreV1Api.createNamespacedServiceAccount(serviceAccountNamespace, serviceAccount).execute();
            Util.notExistsHandler(accountSupplier, accountDefaulter);
            V1ClusterRole clusterRole = (V1ClusterRole)this.yaml("cluster/cluster-role.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readClusterRole(clusterRole.getMetadata().getName()).execute(), () -> this.rbacApi.createClusterRole(clusterRole).execute());
            V1RoleBinding roleBinding = (V1RoleBinding)this.yaml("cluster/role-binding.yaml");
            namespaces.forEach(namespace -> {
                roleBinding.getMetadata().setNamespace(namespace);
                try {
                    Util.notExistsHandler(() -> this.rbacApi.readNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace).execute(), () -> this.rbacApi.createNamespacedRoleBinding(namespace, roleBinding).execute());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteClusterWide(String serviceAccountNamespace, Set<String> namespaces) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("cluster/service-account.yaml");
            V1ClusterRole clusterRole = (V1ClusterRole)this.yaml("cluster/cluster-role.yaml");
            V1RoleBinding roleBinding = (V1RoleBinding)this.yaml("cluster/role-binding.yaml");
            this.coreV1Api.deleteNamespacedServiceAccount(serviceAccount.getMetadata().getName(), serviceAccountNamespace).execute();
            this.rbacApi.deleteClusterRole(clusterRole.getMetadata().getName()).execute();
            namespaces.forEach(namespace -> {
                roleBinding.getMetadata().setNamespace(namespace);
                try {
                    this.rbacApi.deleteNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace).execute();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteNamespace(String name) {
        ApiregistrationV1Api apiInstance = new ApiregistrationV1Api(this.coreV1Api.getApiClient());
        try {
            List apiServices = apiInstance.listAPIService().execute().getItems();
            apiServices.stream().map(apiService -> apiService.getMetadata().getName()).filter(apiServiceName -> apiServiceName.contains("metrics.k8s.io")).findFirst().ifPresent(apiServiceName -> {
                try {
                    apiInstance.deleteAPIService(apiServiceName).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
            this.coreV1Api.deleteNamespace(name).execute();
        }
        catch (ApiException e) {
            System.out.println(e.getResponseBody());
            throw new RuntimeException(e);
        }
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> this.coreV1Api.listNamespace().execute().getItems().stream().noneMatch(x -> x.getMetadata().getName().equals(name)));
    }

    public void wiremock(String namespace, Phase phase, boolean withNodePort) {
        V1Deployment deployment = (V1Deployment)this.yaml("wiremock/wiremock-deployment.yaml");
        String imageWithoutVersion = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.wiremockVersion();
        ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        V1Service service = (V1Service)this.yaml("wiremock/wiremock-service.yaml");
        service.getMetadata().setNamespace(namespace);
        if (!withNodePort) {
            ((V1ServicePort)service.getSpec().getPorts().get(0)).setNodePort(null);
            service.getSpec().setType("ClusterIP");
        }
        if (phase.equals((Object)Phase.CREATE)) {
            deployment.getMetadata().setNamespace(namespace);
            service.getMetadata().setNamespace(namespace);
            this.createAndWait(namespace, "wiremock", deployment, service, false);
        } else {
            this.deleteAndWait(namespace, deployment, service);
        }
    }

    public void configWatcher(Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("config-watcher/deployment.yaml");
        V1Service service = (V1Service)this.yaml("config-watcher/service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait("default", deployment.getMetadata().getName(), deployment, service, true);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait("default", deployment, service);
        }
    }

    private String deploymentName(V1Deployment deployment) {
        return deployment.getMetadata().getName();
    }

    private String configMapName(V1ConfigMap configMap) {
        return configMap.getMetadata().getName();
    }

    private String secretName(V1Secret secret) {
        return secret.getMetadata().getName();
    }

    private void waitForDeployment(String namespace, V1Deployment deployment) {
        String deploymentName = this.deploymentName(deployment);
        Awaitility.await().pollDelay(Duration.ofSeconds(5L)).pollInterval(Duration.ofSeconds(5L)).atMost(900L, TimeUnit.SECONDS).until(() -> this.isDeploymentReady(deploymentName, namespace));
    }

    private void waitForConfigMap(String namespace, V1ConfigMap configMap, Phase phase) {
        String configMapName = this.configMapName(configMap);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            if (phase == Phase.DELETE) {
                try {
                    this.coreV1Api.readNamespacedConfigMap(configMapName, namespace).execute();
                }
                catch (ApiException apiException) {
                    if (apiException.getCode() == 404) {
                        return true;
                    }
                    throw new RuntimeException(apiException);
                }
                return false;
            }
            try {
                this.coreV1Api.readNamespacedConfigMap(configMapName, namespace).execute();
            }
            catch (ApiException apiException) {
                if (apiException.getCode() == 404) {
                    return false;
                }
                throw new RuntimeException(apiException);
            }
            return true;
        });
    }

    private void waitForSecret(String namespace, V1Secret secret, Phase phase) {
        String secretName = this.secretName(secret);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            if (phase == Phase.DELETE) {
                try {
                    this.coreV1Api.readNamespacedSecret(secretName, namespace).execute();
                }
                catch (ApiException apiException) {
                    if (apiException.getCode() == 404) {
                        return true;
                    }
                    throw new RuntimeException(apiException);
                }
                return false;
            }
            try {
                this.coreV1Api.readNamespacedSecret(secretName, namespace).execute();
            }
            catch (ApiException apiException) {
                if (apiException.getCode() == 404) {
                    return false;
                }
                throw new RuntimeException(apiException);
            }
            return true;
        });
    }

    private void waitForDeploymentToBeDeleted(String deploymentName, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(180L)).until(() -> {
            try {
                this.appsV1Api.readNamespacedDeployment(deploymentName, namespace).execute();
                return false;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForServiceToBeDeleted(String serviceName, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(180L)).until(() -> {
            try {
                this.coreV1Api.readNamespacedService(serviceName, namespace).execute();
                return false;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForDeploymentPodsToBeDeleted(Map<String, String> labels, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(180L)).until(() -> {
            try {
                int currentNumberOfPods = this.coreV1Api.listNamespacedPod(namespace).labelSelector(Util.labelSelector(labels)).execute().getItems().size();
                return currentNumberOfPods == 0;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private boolean isDeploymentReady(String deploymentName, String namespace) throws ApiException {
        V1Deployment deployment;
        V1DeploymentList deployments = this.appsV1Api.listNamespacedDeployment(namespace).fieldSelector("metadata.name=" + deploymentName).execute();
        if (deployments.getItems().isEmpty()) {
            Assertions.fail((String)("No deployments with the name " + deploymentName));
        }
        if ((deployment = (V1Deployment)deployments.getItems().get(0)).getStatus() != null) {
            Integer availableReplicas = deployment.getStatus().getAvailableReplicas();
            this.logDeploymentConditions(deployment.getStatus().getConditions());
            LOG.info((Object)("Available replicas for " + deploymentName + ": " + (availableReplicas == null ? 0 : availableReplicas)));
            return availableReplicas != null && availableReplicas >= 1;
        }
        return false;
    }

    private void logDeploymentConditions(List<V1DeploymentCondition> conditions) {
        if (conditions != null) {
            for (V1DeploymentCondition condition : conditions) {
                LOG.info((Object)("Deployment Condition Type: " + condition.getType()));
                LOG.info((Object)("Deployment Condition Status: " + condition.getStatus()));
                LOG.info((Object)("Deployment Condition Message: " + condition.getMessage()));
                LOG.info((Object)("Deployment Condition Reason: " + condition.getReason()));
            }
        }
    }

    private static <T> void notExistsHandler(CheckedSupplier<T> callee, CheckedSupplier<T> defaulter) throws Exception {
        try {
            callee.get();
        }
        catch (Exception exception) {
            ApiException apiException;
            if (exception instanceof ApiException && (apiException = (ApiException)((Object)exception)).getCode() == 404) {
                defaulter.get();
                return;
            }
            throw new RuntimeException(exception);
        }
    }

    private static String labelSelector(Map<String, String> labels) {
        return labels.entrySet().stream().map(en -> (String)en.getKey() + "=" + (String)en.getValue()).collect(Collectors.joining(","));
    }

    private static interface CheckedSupplier<T> {
        public T get() throws Exception;
    }
}

