/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.tests.discovery;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public class TestsDiscovery {
    public static void main(String[] args) throws Exception {
        List<String> classpathEntries = TestsDiscovery.entireClasspath();
        List<String> targetClasses = classpathEntries.stream().filter(x -> x.contains("target/classes")).toList();
        List<String> targetTestClasses = targetClasses.stream().map(x -> x.replace("classes", "test-classes")).toList();
        List<String> jars = classpathEntries.stream().filter(x -> x.contains(".jar")).toList();
        List<URL> urls = Stream.of(targetClasses, targetTestClasses, jars).flatMap(Collection::stream).map(x -> TestsDiscovery.toURL(new File((String)x).toPath().toUri())).toList();
        Set paths = Stream.of(targetClasses, targetTestClasses, jars).flatMap(Collection::stream).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
        TestsDiscovery.replaceClassloader(urls);
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClasspathRoots(paths)).build();
        try (LauncherSession session = LauncherFactory.openSession();){
            Launcher launcher = session.getLauncher();
            TestPlan testPlan = launcher.discover(request);
            testPlan.getRoots().stream().flatMap(x -> testPlan.getChildren(x).stream()).map(TestIdentifier::getLegacyReportingName).sorted().forEach(test -> System.out.println("spring.cloud.k8s.test.to.run -> " + test));
        }
    }

    private static void replaceClassloader(List<URL> classpathURLs) {
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader classLoader = URLClassLoader.newInstance(classpathURLs.toArray(new URL[0]), parentClassLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private static List<String> entireClasspath() throws Exception {
        try (Stream<String> lines = Files.lines(Paths.get("/tmp/deps.txt", new String[0]));){
            List<String> list = lines.distinct().toList();
            return list;
        }
    }

    private static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

