/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons;

import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.springframework.cloud.kubernetes.integration.tests.commons.Constants;
import org.springframework.cloud.kubernetes.integration.tests.commons.FixedPortsK3sContainer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import org.testcontainers.containers.Container;
import org.testcontainers.k3s.K3sContainer;
import reactor.netty.http.client.HttpClient;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public final class Commons {
    private static String POM_VERSION;
    private static final Log LOG;

    private Commons() {
        throw new AssertionError((Object)"No instance provided");
    }

    public static K3sContainer container() {
        return FixedPortsK3sContainer.CONTAINER;
    }

    public static void loadSpringCloudKubernetesImage(String project, K3sContainer container) throws Exception {
        Commons.loadImage("springcloud/" + project, Commons.pomVersion(), project, container);
    }

    public static void assertReloadLogStatements(String left, String right, String appLabel) {
        try {
            String appPodName = FixedPortsK3sContainer.CONTAINER.execInContainer(new String[]{"sh", "-c", "kubectl get pods -l app=" + appLabel + " -o=name --no-headers | tr -d '\n'"}).getStdout();
            LOG.info((Object)("appPodName : ->" + appPodName + "<-"));
            Awaitility.await().pollDelay(20L, TimeUnit.SECONDS).pollInterval(Duration.ofSeconds(5L)).atMost(Duration.ofSeconds(120L)).until(() -> {
                Container.ExecResult result = FixedPortsK3sContainer.CONTAINER.execInContainer(new String[]{"sh", "-c", "kubectl logs " + appPodName.trim() + "| grep '" + left + "'"});
                String error = result.getStderr();
                String ok = result.getStdout();
                LOG.info((Object)("error is : -->" + error + "<--"));
                if (ok != null && !ok.isBlank()) {
                    if (!right.isBlank()) {
                        String notPresent = FixedPortsK3sContainer.CONTAINER.execInContainer(new String[]{"sh", "-c", "kubectl logs " + appPodName.trim() + "| grep '" + right + "'"}).getStdout();
                        Assertions.assertTrue((notPresent == null || notPresent.isBlank() ? 1 : 0) != 0);
                    }
                    return true;
                }
                LOG.info((Object)"log statement not yet present");
                return false;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadImage(String image, String tag, String tarName, K3sContainer container) throws Exception {
        if (Commons.imageAlreadyInK3s(container, tarName)) {
            return;
        }
        try (SaveImageCmd saveImageCmd = container.getDockerClient().saveImageCmd(image);){
            InputStream imageStream = saveImageCmd.withTag(tag).exec();
            Path imagePath = Paths.get(Constants.TEMP_FOLDER + "/" + tarName + ".tar", new String[0]);
            Files.copy(imageStream, imagePath, StandardCopyOption.REPLACE_EXISTING);
            Awaitility.await().atMost(Duration.ofMinutes(2L)).pollInterval(Duration.ofSeconds(1L)).until(() -> {
                boolean noErrors;
                Container.ExecResult result = container.execInContainer(new String[]{"ctr", "i", "import", Constants.TEMP_FOLDER + "/" + tarName + ".tar"});
                boolean bl = noErrors = result.getStderr() == null || result.getStderr().isEmpty();
                if (!noErrors) {
                    LOG.info((Object)("error is : " + result.getStderr()));
                }
                return noErrors;
            });
        }
    }

    public static void load(K3sContainer container, String tarName, String imageNameForDownload, String imageVersion) {
        if (Commons.imageAlreadyInK3s(container, tarName)) {
            return;
        }
        File dockerImagesRootDir = Paths.get("/tmp/docker/images", new String[0]).toFile();
        if (dockerImagesRootDir.exists() && dockerImagesRootDir.isDirectory()) {
            File[] tars = dockerImagesRootDir.listFiles();
            if (tars != null && tars.length > 0) {
                Optional<String> found = Arrays.stream(tars).map(File::getName).filter(x -> x.contains(tarName)).findFirst();
                if (found.isPresent()) {
                    LOG.info((Object)("running in github actions, will load from : /tmp/docker/images tar : " + found.get()));
                    Commons.loadImageFromPath(found.get(), container);
                    return;
                }
                LOG.info((Object)(tarName + " not found, resorting to pulling the image"));
            } else {
                LOG.info((Object)"no tars found, will resort to pulling the image");
            }
        } else {
            LOG.info((Object)"running outside github actions");
        }
        try {
            LOG.info((Object)"no tars found, will resort to pulling the image");
            LOG.info((Object)("using : " + imageVersion + " for : " + imageNameForDownload));
            Commons.pullImage(imageNameForDownload, imageVersion, tarName, container);
            Commons.loadImage(imageNameForDownload, imageVersion, tarName, container);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void validateImage(String image, K3sContainer container) {
        try (ListImagesCmd listImagesCmd = container.getDockerClient().listImagesCmd();){
            List images = (List)listImagesCmd.exec();
            images.stream().filter(x -> Arrays.stream(x.getRepoTags() == null ? new String[]{} : x.getRepoTags()).anyMatch(y -> y.contains(image))).findFirst().orElseThrow(() -> new IllegalArgumentException("Image : " + image + " not build locally. You need to build it first, and then run the test"));
        }
    }

    public static void pullImage(String image, String tag, String tarName, K3sContainer container) throws InterruptedException {
        if (Commons.imageAlreadyInK3s(container, tarName)) {
            return;
        }
        try (PullImageCmd pullImageCmd = container.getDockerClient().pullImageCmd(image);){
            pullImageCmd.withTag(tag).start().awaitCompletion();
        }
    }

    public static String pomVersion() {
        if (POM_VERSION == null) {
            try (InputStream in = new ClassPathResource("META-INF/springcloudkubernetes-version.txt").getInputStream();){
                String version = StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (StringUtils.hasText((String)version)) {
                    POM_VERSION = version.trim();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return POM_VERSION;
    }

    public static void waitForLogStatement(String message, K3sContainer k3sContainer, String appLabelValue) {
        try {
            Awaitility.await().atMost(Duration.ofMinutes(2L)).pollInterval(Duration.ofSeconds(4L)).until(() -> {
                String appPodName = k3sContainer.execInContainer(new String[]{"sh", "-c", "kubectl get pods -l app=" + appLabelValue + " -o custom-columns=POD:metadata.name,STATUS:status.phase | grep -i 'running' | awk '{print $1}' | tr -d '\n' "}).getStdout();
                String execResult = k3sContainer.execInContainer(new String[]{"sh", "-c", "kubectl logs " + appPodName.trim()}).getStdout();
                return execResult.contains(message);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static WebClient.Builder builder() {
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(HttpClient.create()));
    }

    public static RetryBackoffSpec retrySpec() {
        return Retry.fixedDelay((long)15L, (Duration)Duration.ofSeconds(1L)).filter(Objects::nonNull);
    }

    private static void loadImageFromPath(String tarName, K3sContainer container) {
        Awaitility.await().atMost(Duration.ofMinutes(2L)).pollInterval(Duration.ofSeconds(1L)).until(() -> {
            boolean noErrors;
            Container.ExecResult result = container.execInContainer(new String[]{"ctr", "i", "import", "/tmp/docker/images/" + tarName});
            boolean bl = noErrors = result.getStderr() == null || result.getStderr().isEmpty();
            if (!noErrors) {
                LOG.info((Object)("error is : " + result.getStderr()));
            }
            return noErrors;
        });
    }

    private static boolean imageAlreadyInK3s(K3sContainer container, String tarName) {
        if (tarName == null) {
            return false;
        }
        try {
            boolean present = container.execInContainer(new String[]{"sh", "-c", "ctr images list | grep " + tarName}).getStdout().contains(tarName);
            if (present) {
                System.out.println("image : " + tarName + " already in k3s, skipping");
                return true;
            }
            System.out.println("image : " + tarName + " not in k3s");
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LOG = LogFactory.getLog(Commons.class);
    }
}

