/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons;

import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.HostConfig;
import java.util.Objects;
import org.springframework.cloud.kubernetes.integration.tests.commons.Constants;
import org.testcontainers.k3s.K3sContainer;
import org.testcontainers.utility.DockerImageName;

final class FixedPortsK3sContainer
extends K3sContainer {
    private static final int[] EXPOSED_PORTS = new int[]{80, 6443, 8080, 8888, 9092};
    private static final String RANCHER_VERSION = "rancher/k3s:v1.28.8-k3s1";
    private static final String RANCHER_COMMAND = "server --disable=metric-server";
    static final K3sContainer CONTAINER = (K3sContainer)((K3sContainer)new FixedPortsK3sContainer(DockerImageName.parse((String)"rancher/k3s:v1.28.8-k3s1")).configureFixedPorts().addBinds().withCommand("server --disable=metric-server")).withReuse(true);

    FixedPortsK3sContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
    }

    FixedPortsK3sContainer configureFixedPorts() {
        for (int port : EXPOSED_PORTS) {
            super.addFixedExposedPort(port, port);
        }
        return this;
    }

    FixedPortsK3sContainer addBinds() {
        super.withCreateContainerCmdModifier(cmd -> {
            HostConfig hostConfig = Objects.requireNonNull(cmd.getHostConfig());
            hostConfig.withBinds(new Bind[]{Bind.parse((String)(Constants.TEMP_FOLDER + ":" + Constants.TEMP_FOLDER)), Bind.parse((String)"/tmp/docker/images:/tmp/docker/images")});
        });
        return this;
    }
}

