/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons.native_client;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.apis.RbacAuthorizationV1Api;
import io.kubernetes.client.openapi.models.V1ClusterRole;
import io.kubernetes.client.openapi.models.V1ClusterRoleBinding;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentCondition;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerStatus;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1NamespaceBuilder;
import io.kubernetes.client.openapi.models.V1NamespaceFluent;
import io.kubernetes.client.openapi.models.V1Role;
import io.kubernetes.client.openapi.models.V1RoleBinding;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.PatchUtils;
import io.kubernetes.client.util.Yaml;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.springframework.cloud.kubernetes.integration.tests.commons.Commons;
import org.springframework.cloud.kubernetes.integration.tests.commons.Images;
import org.springframework.cloud.kubernetes.integration.tests.commons.Phase;
import org.testcontainers.k3s.K3sContainer;

public final class Util {
    private static final Log LOG = LogFactory.getLog(Util.class);
    private final CoreV1Api coreV1Api;
    private final AppsV1Api appsV1Api;
    private final NetworkingV1Api networkingV1Api;
    private final RbacAuthorizationV1Api rbacApi;
    private final K3sContainer container;

    public Util(K3sContainer container) {
        ApiClient client;
        try {
            client = Config.fromConfig((Reader)new StringReader(container.getKubeConfigYaml()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        client.setHttpClient(client.getHttpClient().newBuilder().readTimeout(Duration.ofSeconds(15L)).build());
        client.setDebugging(false);
        Configuration.setDefaultApiClient((ApiClient)client);
        this.container = container;
        this.coreV1Api = new CoreV1Api();
        this.appsV1Api = new AppsV1Api();
        this.networkingV1Api = new NetworkingV1Api();
        this.rbacApi = new RbacAuthorizationV1Api();
    }

    public void createAndWait(String namespace, String name, V1Deployment deployment, V1Service service, @Nullable V1Ingress ingress, boolean changeVersion) {
        try {
            this.coreV1Api.createNamespacedService(namespace, service, null, null, null, null);
            if (deployment != null) {
                String imageFromDeployment = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
                if (changeVersion) {
                    ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageFromDeployment + ":" + Commons.pomVersion());
                } else {
                    String[] image = imageFromDeployment.split(":", 2);
                    Commons.pullImage(image[0], image[1], this.container);
                    Commons.loadImage(image[0], image[1], name, this.container);
                }
                this.appsV1Api.createNamespacedDeployment(namespace, deployment, null, null, null, null);
                this.waitForDeployment(namespace, deployment);
            }
            if (ingress != null) {
                this.networkingV1Api.createNamespacedIngress(namespace, ingress, null, null, null, null);
                this.waitForIngress(namespace, ingress);
            }
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                ApiException apiException = (ApiException)((Object)e);
                System.out.println(apiException.getResponseBody());
            }
            throw new RuntimeException(e);
        }
    }

    public void createAndWait(String namespace, @Nullable V1ConfigMap configMap, @Nullable V1Secret secret) {
        try {
            if (configMap != null) {
                this.coreV1Api.createNamespacedConfigMap(namespace, configMap, null, null, null, null);
                this.waitForConfigMap(namespace, configMap, Phase.CREATE);
            }
            if (secret != null) {
                this.coreV1Api.createNamespacedSecret(namespace, secret, null, null, null, null);
                this.waitForSecret(namespace, secret, Phase.CREATE);
            }
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAndWait(String namespace, @Nullable V1ConfigMap configMap, @Nullable V1Secret secret) {
        try {
            if (configMap != null) {
                String configMapName = this.configMapName(configMap);
                this.coreV1Api.deleteNamespacedConfigMap(configMapName, namespace, null, null, null, null, null, null);
                this.waitForConfigMap(namespace, configMap, Phase.DELETE);
            }
            if (secret != null) {
                String secretName = this.secretName(secret);
                this.coreV1Api.deleteNamespacedSecret(secretName, namespace, null, null, null, null, null, null);
                this.waitForSecret(namespace, secret, Phase.DELETE);
            }
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void createNamespace(String name) {
        try {
            this.coreV1Api.createNamespace(((V1NamespaceBuilder)((V1NamespaceFluent.MetadataNested)new V1NamespaceBuilder().withNewMetadata().withName(name)).and()).build(), null, null, null, null);
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAndWait(String namespace, V1Deployment deployment, V1Service service, @Nullable V1Ingress ingress) {
        if (deployment != null) {
            try {
                String deploymentName = this.deploymentName(deployment);
                Map podLabels = this.appsV1Api.readNamespacedDeployment(deploymentName, namespace, null).getSpec().getTemplate().getMetadata().getLabels();
                this.appsV1Api.deleteNamespacedDeployment(deploymentName, namespace, null, null, null, null, null, null);
                this.coreV1Api.deleteCollectionNamespacedPod(namespace, null, null, null, null, null, Util.labelSelector(podLabels), null, null, null, null, null, null, null, null);
                this.waitForDeploymentToBeDeleted(deploymentName, namespace);
                this.waitForDeploymentPodsToBeDeleted(podLabels, namespace);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String serviceName = this.serviceName(service);
        try {
            this.coreV1Api.deleteNamespacedService(serviceName, namespace, null, null, null, null, null, null);
            if (ingress != null) {
                String ingressName = this.ingressName(ingress);
                this.networkingV1Api.deleteNamespacedIngress(ingressName, namespace, null, null, null, null, null, null);
                this.waitForIngressToBeDeleted(ingressName, namespace);
            }
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void busybox(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("busybox/deployment.yaml");
        String imageWithoutVersion = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.busyboxVersion();
        ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        V1Service service = (V1Service)this.yaml("busybox/service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "busybox", deployment, service, null, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service, null);
        }
    }

    public void kafka(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("kafka/kafka-deployment.yaml");
        String imageWithoutVersion = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.kafkaVersion();
        ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        V1Service service = (V1Service)this.yaml("kafka/kafka-service.yaml");
        V1ConfigMap configMap = (V1ConfigMap)this.yaml("kafka/kafka-configmap-startup-script.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, configMap, null);
            this.createAndWait(namespace, "kafka", deployment, service, null, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, configMap, null);
            this.deleteAndWait(namespace, deployment, service, null);
        }
    }

    public void rabbitMq(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("rabbitmq/rabbitmq-deployment.yaml");
        String imageWithoutVersion = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.rabbitMqVersion();
        ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        V1Service service = (V1Service)this.yaml("rabbitmq/rabbitmq-service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "rabbitmq", deployment, service, null, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service, null);
        }
    }

    public Object yaml(String fileName) {
        ClassLoader classLoader = Util.class.getClassLoader();
        String file = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(fileName))).lines().collect(Collectors.joining("\n"));
        try {
            return Yaml.load((String)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUp(String namespace) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("setup/service-account.yaml");
            CheckedSupplier<V1ServiceAccount> accountSupplier = () -> this.coreV1Api.readNamespacedServiceAccount(serviceAccount.getMetadata().getName(), namespace, null);
            CheckedSupplier<V1ServiceAccount> accountDefaulter = () -> this.coreV1Api.createNamespacedServiceAccount(namespace, serviceAccount, null, null, null, null);
            Util.notExistsHandler(accountSupplier, accountDefaulter);
            V1RoleBinding roleBinding = (V1RoleBinding)this.yaml("setup/role-binding.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace, null), () -> this.rbacApi.createNamespacedRoleBinding(namespace, roleBinding, null, null, null, null));
            V1Role role = (V1Role)this.yaml("setup/role.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readNamespacedRole(role.getMetadata().getName(), namespace, null), () -> this.rbacApi.createNamespacedRole(namespace, role, null, null, null, null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setUpClusterWideClusterRoleBinding(String serviceAccountNamespace) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("cluster/service-account.yaml");
            CheckedSupplier<V1ServiceAccount> accountSupplier = () -> this.coreV1Api.readNamespacedServiceAccount(serviceAccount.getMetadata().getName(), serviceAccountNamespace, null);
            CheckedSupplier<V1ServiceAccount> accountDefaulter = () -> this.coreV1Api.createNamespacedServiceAccount(serviceAccountNamespace, serviceAccount, null, null, null, null);
            Util.notExistsHandler(accountSupplier, accountDefaulter);
            V1ClusterRole clusterRole = (V1ClusterRole)this.yaml("cluster/cluster-role.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readClusterRole(clusterRole.getMetadata().getName(), null), () -> this.rbacApi.createClusterRole(clusterRole, null, null, null, null));
            V1ClusterRoleBinding clusterRoleBinding = (V1ClusterRoleBinding)this.yaml("cluster/cluster-role-binding.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readClusterRoleBinding(clusterRoleBinding.getMetadata().getName(), null), () -> this.rbacApi.createClusterRoleBinding(clusterRoleBinding, null, null, null, null));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void deleteClusterWideClusterRoleBinding(String serviceAccountNamespace) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("cluster/service-account.yaml");
            V1ClusterRole clusterRole = (V1ClusterRole)this.yaml("cluster/cluster-role.yaml");
            V1ClusterRoleBinding clusterRoleBinding = (V1ClusterRoleBinding)this.yaml("cluster/cluster-role-binding.yaml");
            this.coreV1Api.deleteNamespacedServiceAccount(serviceAccount.getMetadata().getName(), serviceAccountNamespace, null, null, null, null, null, null);
            this.rbacApi.deleteClusterRole(clusterRole.getMetadata().getName(), null, null, null, null, null, null);
            this.rbacApi.deleteClusterRoleBinding(clusterRoleBinding.getMetadata().getName(), null, null, null, null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void setUpClusterWide(String serviceAccountNamespace, Set<String> namespaces) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("cluster/service-account.yaml");
            CheckedSupplier<V1ServiceAccount> accountSupplier = () -> this.coreV1Api.readNamespacedServiceAccount(serviceAccount.getMetadata().getName(), serviceAccountNamespace, null);
            CheckedSupplier<V1ServiceAccount> accountDefaulter = () -> this.coreV1Api.createNamespacedServiceAccount(serviceAccountNamespace, serviceAccount, null, null, null, null);
            Util.notExistsHandler(accountSupplier, accountDefaulter);
            V1ClusterRole clusterRole = (V1ClusterRole)this.yaml("cluster/cluster-role.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readClusterRole(clusterRole.getMetadata().getName(), null), () -> this.rbacApi.createClusterRole(clusterRole, null, null, null, null));
            V1RoleBinding roleBinding = (V1RoleBinding)this.yaml("cluster/role-binding.yaml");
            namespaces.forEach(namespace -> {
                roleBinding.getMetadata().setNamespace(namespace);
                try {
                    Util.notExistsHandler(() -> this.rbacApi.readNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace, null), () -> this.rbacApi.createNamespacedRoleBinding(namespace, roleBinding, null, null, null, null));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteClusterWide(String serviceAccountNamespace, Set<String> namespaces) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("cluster/service-account.yaml");
            V1ClusterRole clusterRole = (V1ClusterRole)this.yaml("cluster/cluster-role.yaml");
            V1RoleBinding roleBinding = (V1RoleBinding)this.yaml("cluster/role-binding.yaml");
            this.coreV1Api.deleteNamespacedServiceAccount(serviceAccount.getMetadata().getName(), serviceAccountNamespace, null, null, null, null, null, null);
            this.rbacApi.deleteClusterRole(clusterRole.getMetadata().getName(), null, null, null, null, null, null);
            namespaces.forEach(namespace -> {
                roleBinding.getMetadata().setNamespace(namespace);
                try {
                    this.rbacApi.deleteNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace, null, null, null, null, null, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteNamespace(String name) {
        try {
            this.coreV1Api.deleteNamespace(name, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> this.coreV1Api.listNamespace(null, null, null, null, null, null, null, null, null, null, null).getItems().stream().noneMatch(x -> x.getMetadata().getName().equals(name)));
    }

    public void wiremock(String namespace, String path, Phase phase) {
        this.wiremock(namespace, path, phase, true);
    }

    public void wiremock(String namespace, String path, Phase phase, boolean withIngress) {
        V1Deployment deployment = (V1Deployment)this.yaml("wiremock/wiremock-deployment.yaml");
        String imageWithoutVersion = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.wiremockVersion();
        ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        V1Service service = (V1Service)this.yaml("wiremock/wiremock-service.yaml");
        V1Ingress ingress = null;
        if (phase.equals((Object)Phase.CREATE)) {
            if (withIngress) {
                ingress = (V1Ingress)this.yaml("wiremock/wiremock-ingress.yaml");
                ingress.getMetadata().setNamespace(namespace);
                ((V1HTTPIngressPath)((V1IngressRule)ingress.getSpec().getRules().get(0)).getHttp().getPaths().get(0)).setPath(path);
            }
            deployment.getMetadata().setNamespace(namespace);
            service.getMetadata().setNamespace(namespace);
            this.createAndWait(namespace, "wiremock", deployment, service, ingress, false);
        } else {
            if (withIngress) {
                ingress = (V1Ingress)this.yaml("wiremock/wiremock-ingress.yaml");
            }
            this.deleteAndWait(namespace, deployment, service, ingress);
        }
    }

    public static void patchWithMerge(String deploymentName, String namespace, String patchBody, Map<String, String> podLabels) {
        try {
            PatchUtils.patch(V1Deployment.class, () -> new AppsV1Api().patchNamespacedDeploymentCall(deploymentName, namespace, new V1Patch(patchBody), null, null, null, null, null, null), (String)"application/strategic-merge-patch+json", (ApiClient)new CoreV1Api().getApiClient());
        }
        catch (ApiException e) {
            LOG.error((Object)("error : " + e.getResponseBody()));
            throw new RuntimeException(e);
        }
        Util.waitForDeploymentAfterPatch(deploymentName, namespace, podLabels);
    }

    public static void patchWithReplace(String imageName, String deploymentName, String namespace, String patchBody, Map<String, String> podLabels) {
        String body = patchBody.replace("image_name_here", imageName);
        try {
            PatchUtils.patch(V1Deployment.class, () -> new AppsV1Api().patchNamespacedDeploymentCall(deploymentName, namespace, new V1Patch(body), null, null, null, null, null, null), (String)"application/merge-patch+json", (ApiClient)new CoreV1Api().getApiClient());
        }
        catch (ApiException e) {
            LOG.error((Object)("error : " + e.getResponseBody()));
            throw new RuntimeException(e);
        }
        Util.waitForDeploymentAfterPatch(deploymentName, namespace, podLabels);
    }

    private String deploymentName(V1Deployment deployment) {
        return deployment.getMetadata().getName();
    }

    private String serviceName(V1Service service) {
        return service.getMetadata().getName();
    }

    private String ingressName(V1Ingress ingress) {
        return ingress.getMetadata().getName();
    }

    private String configMapName(V1ConfigMap configMap) {
        return configMap.getMetadata().getName();
    }

    private String secretName(V1Secret secret) {
        return secret.getMetadata().getName();
    }

    private void waitForDeployment(String namespace, V1Deployment deployment) {
        String deploymentName = this.deploymentName(deployment);
        Awaitility.await().pollDelay(Duration.ofSeconds(5L)).pollInterval(Duration.ofSeconds(5L)).atMost(900L, TimeUnit.SECONDS).until(() -> this.isDeploymentReady(deploymentName, namespace));
    }

    private void waitForConfigMap(String namespace, V1ConfigMap configMap, Phase phase) {
        String configMapName = this.configMapName(configMap);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            try {
                this.coreV1Api.readNamespacedConfigMap(configMapName, namespace, null);
                return phase.equals((Object)Phase.CREATE);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return !phase.equals((Object)Phase.CREATE);
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForSecret(String namespace, V1Secret secret, Phase phase) {
        String secretName = this.secretName(secret);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            try {
                this.coreV1Api.readNamespacedSecret(secretName, namespace, null);
                return phase.equals((Object)Phase.CREATE);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return !phase.equals((Object)Phase.CREATE);
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForIngress(String namespace, V1Ingress ingress) {
        String ingressName = this.ingressName(ingress);
        Awaitility.await().timeout(Duration.ofSeconds(90L)).pollInterval(Duration.ofSeconds(3L)).until(() -> {
            try {
                V1IngressLoadBalancerStatus status = this.networkingV1Api.readNamespacedIngress(ingressName, namespace, null).getStatus().getLoadBalancer();
                if (status == null) {
                    LOG.info((Object)("ingress : " + ingressName + " not ready yet (loadbalancer not yet present)"));
                    return false;
                }
                List loadBalancerIngress = status.getIngress();
                if (loadBalancerIngress == null) {
                    LOG.info((Object)("ingress : " + ingressName + " not ready yet (loadbalancer ingress not yet present)"));
                    return false;
                }
                String ip = ((V1IngressLoadBalancerIngress)loadBalancerIngress.get(0)).getIp();
                if (ip == null) {
                    LOG.info((Object)("ingress : " + ingressName + " not ready yet"));
                    return false;
                }
                LOG.info((Object)("ingress : " + ingressName + " ready with ip : " + ip));
                return true;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return false;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForDeploymentToBeDeleted(String deploymentName, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(180L)).until(() -> {
            try {
                this.appsV1Api.readNamespacedDeployment(deploymentName, namespace, null);
                return false;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForDeploymentPodsToBeDeleted(Map<String, String> labels, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(180L)).until(() -> {
            try {
                int currentNumberOfPods = this.coreV1Api.listNamespacedPod(namespace, null, null, null, null, Util.labelSelector(labels), null, null, null, null, null, null).getItems().size();
                return currentNumberOfPods == 0;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForIngressToBeDeleted(String ingressName, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(90L)).until(() -> {
            try {
                this.networkingV1Api.readNamespacedIngress(ingressName, namespace, null);
                return false;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private boolean isDeploymentReady(String deploymentName, String namespace) throws ApiException {
        V1Deployment deployment;
        V1DeploymentList deployments = this.appsV1Api.listNamespacedDeployment(namespace, null, null, null, "metadata.name=" + deploymentName, null, null, null, null, null, null, null);
        if (deployments.getItems().isEmpty()) {
            Assertions.fail((String)("No deployments with the name " + deploymentName));
        }
        if ((deployment = (V1Deployment)deployments.getItems().get(0)).getStatus() != null) {
            Integer availableReplicas = deployment.getStatus().getAvailableReplicas();
            this.logDeploymentConditions(deployment.getStatus().getConditions());
            LOG.info((Object)("Available replicas for " + deploymentName + ": " + (availableReplicas == null ? 0 : availableReplicas)));
            return availableReplicas != null && availableReplicas >= 1;
        }
        return false;
    }

    private void logDeploymentConditions(List<V1DeploymentCondition> conditions) {
        if (conditions != null) {
            for (V1DeploymentCondition condition : conditions) {
                LOG.info((Object)("Deployment Condition Type: " + condition.getType()));
                LOG.info((Object)("Deployment Condition Status: " + condition.getStatus()));
                LOG.info((Object)("Deployment Condition Message: " + condition.getMessage()));
                LOG.info((Object)("Deployment Condition Reason: " + condition.getReason()));
            }
        }
    }

    private static void waitForDeploymentAfterPatch(String deploymentName, String namespace, Map<String, String> podLabels) {
        try {
            Awaitility.await().pollDelay(Duration.ofSeconds(4L)).pollInterval(Duration.ofSeconds(3L)).atMost(60L, TimeUnit.SECONDS).until(() -> Util.isDeploymentReadyAfterPatch(deploymentName, namespace, podLabels));
        }
        catch (Exception e) {
            if (e instanceof ApiException) {
                ApiException apiException = (ApiException)((Object)e);
                LOG.error((Object)"Error: ");
                LOG.error((Object)apiException.getResponseBody());
            }
            throw new RuntimeException(e);
        }
    }

    private static boolean isDeploymentReadyAfterPatch(String deploymentName, String namespace, Map<String, String> podLabels) throws ApiException {
        V1DeploymentList deployments = new AppsV1Api().listNamespacedDeployment(namespace, null, null, null, "metadata.name=" + deploymentName, null, null, null, null, null, null, null);
        if (deployments.getItems().isEmpty()) {
            Assertions.fail((String)("No deployment with name " + deploymentName));
        }
        V1Deployment deployment = (V1Deployment)deployments.getItems().get(0);
        int replicas = Optional.ofNullable(deployment.getSpec().getReplicas()).orElse(1);
        int readyReplicas = Optional.ofNullable(deployment.getStatus().getReadyReplicas()).orElse(0);
        if (readyReplicas != replicas) {
            LOG.info((Object)"ready replicas not yet same as replicas");
            return false;
        }
        int pods = new CoreV1Api().listNamespacedPod(namespace, null, null, null, null, Util.labelSelector(podLabels), null, null, null, null, null, null).getItems().size();
        if (pods != replicas) {
            LOG.info((Object)"number of pods not yet stabilized");
            return false;
        }
        return true;
    }

    private static <T> void notExistsHandler(CheckedSupplier<T> callee, CheckedSupplier<T> defaulter) throws Exception {
        try {
            callee.get();
        }
        catch (Exception exception) {
            ApiException apiException;
            if (exception instanceof ApiException && (apiException = (ApiException)((Object)exception)).getCode() == 404) {
                defaulter.get();
                return;
            }
            throw new RuntimeException(exception);
        }
    }

    private static String labelSelector(Map<String, String> labels) {
        return labels.entrySet().stream().map(en -> (String)en.getKey() + "=" + (String)en.getValue()).collect(Collectors.joining(","));
    }

    private static interface CheckedSupplier<T> {
        public T get() throws Exception;
    }
}

