/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons.fabric8_client;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.springframework.cloud.kubernetes.integration.tests.commons.Commons;
import org.springframework.cloud.kubernetes.integration.tests.commons.Phase;
import org.testcontainers.k3s.K3sContainer;

public final class Util {
    private static final Log LOG = LogFactory.getLog(Util.class);
    private final K3sContainer container;
    private final KubernetesClient client;

    public Util(K3sContainer container) {
        this.container = container;
        this.client = new KubernetesClientBuilder().withConfig(Config.fromKubeconfig((String)container.getKubeConfigYaml())).build();
    }

    public void createAndWait(String namespace, String name, @Nullable Deployment deployment, Service service, @Nullable Ingress ingress, boolean changeVersion) {
        try {
            if (deployment != null) {
                String imageFromDeployment = ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
                if (changeVersion) {
                    ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageFromDeployment + ":" + Commons.pomVersion());
                } else {
                    String[] image = imageFromDeployment.split(":", 2);
                    Commons.pullImage(image[0], image[1], this.container);
                    Commons.loadImage(image[0], image[1], name, this.container);
                }
                ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).resource((Object)deployment)).create();
                this.waitForDeployment(namespace, deployment);
            }
            ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).resource((Object)service)).create();
            if (ingress != null) {
                ((Resource)((NonNamespaceOperation)this.client.network().v1().ingresses().inNamespace(namespace)).resource((Object)ingress)).create();
                this.waitForIngress(namespace, ingress);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void busybox(String namespace, Phase phase) {
        InputStream deploymentStream = this.inputStream("busybox/deployment.yaml");
        InputStream serviceStream = this.inputStream("busybox/service.yaml");
        Deployment deployment = (Deployment)((RollableScalableResource)this.client.apps().deployments().load(deploymentStream)).get();
        Service service = (Service)((ServiceResource)this.client.services().load(serviceStream)).get();
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "busybox", deployment, service, null, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service, null);
        }
    }

    public void deleteAndWait(String namespace, @Nullable Deployment deployment, Service service, @Nullable Ingress ingress) {
        try {
            if (deployment != null) {
                ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).resource((Object)deployment)).delete();
                this.waitForDeploymentToBeDeleted(namespace, deployment);
            }
            ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).resource((Object)service)).delete();
            if (ingress != null) {
                ((Resource)((NonNamespaceOperation)this.client.network().v1().ingresses().inNamespace(namespace)).resource((Object)ingress)).delete();
                this.waitForIngressToBeDeleted(namespace, ingress);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setUp(String namespace) throws Exception {
        InputStream serviceAccountAsStream = this.inputStream("setup/service-account.yaml");
        InputStream roleBindingAsStream = this.inputStream("setup/role-binding.yaml");
        InputStream roleAsStream = this.inputStream("setup/role.yaml");
        this.innerSetup(namespace, serviceAccountAsStream, roleBindingAsStream, roleAsStream);
    }

    public InputStream inputStream(String fileName) {
        return Util.class.getClassLoader().getResourceAsStream(fileName);
    }

    public void createNamespace(String name) {
        try {
            ((Resource)this.client.namespaces().resource((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(name)).and()).build())).create();
            Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> ((NamespaceList)this.client.namespaces().list()).getItems().stream().anyMatch(x -> x.getMetadata().getName().equals(name)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteNamespace(String name) {
        try {
            ((Resource)this.client.namespaces().resource((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(name)).and()).build())).delete();
            Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> ((NamespaceList)this.client.namespaces().list()).getItems().stream().noneMatch(x -> x.getMetadata().getName().equals(name)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setUpClusterWide(String serviceAccountNamespace, Set<String> namespaces) {
        InputStream clusterRoleBindingAsStream = this.inputStream("cluster/cluster-role.yaml");
        InputStream serviceAccountAsStream = this.inputStream("cluster/service-account.yaml");
        InputStream roleBindingAsStream = this.inputStream("cluster/role-binding.yaml");
        ClusterRole clusterRole = (ClusterRole)((Resource)this.client.rbac().clusterRoles().load(clusterRoleBindingAsStream)).get();
        if (((Resource)this.client.rbac().clusterRoles().withName(clusterRole.getMetadata().getName())).get() == null) {
            ((Resource)this.client.rbac().clusterRoles().resource((Object)clusterRole)).create();
        }
        ServiceAccount serviceAccountFromStream = (ServiceAccount)((Resource)this.client.serviceAccounts().load(serviceAccountAsStream)).get();
        serviceAccountFromStream.getMetadata().setNamespace(serviceAccountNamespace);
        if (((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(serviceAccountNamespace)).withName(serviceAccountFromStream.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(serviceAccountNamespace)).resource((Object)serviceAccountFromStream)).create();
        }
        RoleBinding roleBindingFromStream = (RoleBinding)((Resource)this.client.rbac().roleBindings().load(roleBindingAsStream)).get();
        namespaces.forEach(namespace -> {
            roleBindingFromStream.getMetadata().setNamespace(namespace);
            if (((Resource)((NonNamespaceOperation)this.client.rbac().roleBindings().inNamespace(namespace)).withName(roleBindingFromStream.getMetadata().getName())).get() == null) {
                ((Resource)((NonNamespaceOperation)this.client.rbac().roleBindings().inNamespace(namespace)).resource((Object)roleBindingFromStream)).create();
            }
        });
    }

    public void createAndWait(String namespace, @Nullable ConfigMap configMap, @Nullable Secret secret) {
        if (configMap != null) {
            ((Resource)this.client.configMaps().resource((Object)configMap)).create();
            this.waitForConfigMap(namespace, configMap, Phase.CREATE);
        }
        if (secret != null) {
            ((Resource)this.client.secrets().resource((Object)secret)).create();
            this.waitForSecret(namespace, secret, Phase.CREATE);
        }
    }

    public void deleteAndWait(String namespace, @Nullable ConfigMap configMap, @Nullable Secret secret) {
        if (configMap != null) {
            ((Resource)this.client.configMaps().resource((Object)configMap)).delete();
            this.waitForConfigMap(namespace, configMap, Phase.DELETE);
        }
        if (secret != null) {
            ((Resource)this.client.secrets().resource((Object)secret)).delete();
            this.waitForSecret(namespace, secret, Phase.DELETE);
        }
    }

    public void setUpIstio(String namespace) {
        InputStream serviceAccountAsStream = this.inputStream("istio/service-account.yaml");
        InputStream roleBindingAsStream = this.inputStream("istio/role-binding.yaml");
        InputStream roleAsStream = this.inputStream("istio/role.yaml");
        this.innerSetup(namespace, serviceAccountAsStream, roleBindingAsStream, roleAsStream);
    }

    private void waitForConfigMap(String namespace, ConfigMap configMap, Phase phase) {
        String configMapName = this.configMapName(configMap);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            int size = (int)((ConfigMapList)((NonNamespaceOperation)this.client.configMaps().inNamespace(namespace)).list()).getItems().stream().filter(x -> x.getMetadata().getName().equals(configMapName)).count();
            if (size == 0) {
                return !phase.equals((Object)Phase.CREATE);
            }
            return phase.equals((Object)Phase.CREATE);
        });
    }

    public void wiremock(String namespace, String path, Phase phase) {
        this.wiremock(namespace, path, phase, true);
    }

    public void wiremock(String namespace, String path, Phase phase, boolean withIngress) {
        InputStream deploymentStream = this.inputStream("wiremock/wiremock-deployment.yaml");
        InputStream serviceStream = this.inputStream("wiremock/wiremock-service.yaml");
        InputStream ingressStream = this.inputStream("wiremock/wiremock-ingress.yaml");
        Deployment deployment = (Deployment)((RollableScalableResource)this.client.apps().deployments().load(deploymentStream)).get();
        Service service = (Service)((ServiceResource)this.client.services().load(serviceStream)).get();
        Ingress ingress = null;
        if (phase.equals((Object)Phase.CREATE)) {
            if (withIngress) {
                ingress = (Ingress)((Resource)this.client.network().v1().ingresses().load(ingressStream)).get();
                ingress.getMetadata().setNamespace(namespace);
                ((HTTPIngressPath)((IngressRule)ingress.getSpec().getRules().get(0)).getHttp().getPaths().get(0)).setPath(path);
            }
            deployment.getMetadata().setNamespace(namespace);
            service.getMetadata().setNamespace(namespace);
            this.createAndWait(namespace, "wiremock", deployment, service, ingress, false);
        } else {
            if (withIngress) {
                ingress = (Ingress)((Resource)this.client.network().v1().ingresses().load(ingressStream)).get();
            }
            this.deleteAndWait(namespace, deployment, service, ingress);
        }
    }

    private void waitForSecret(String namespace, Secret secret, Phase phase) {
        String secretName = this.secretName(secret);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            int size = (int)((SecretList)((NonNamespaceOperation)this.client.secrets().inNamespace(namespace)).list()).getItems().stream().filter(x -> x.getMetadata().getName().equals(secretName)).count();
            if (size == 0) {
                return !phase.equals((Object)Phase.CREATE);
            }
            return phase.equals((Object)Phase.CREATE);
        });
    }

    private void waitForIngressToBeDeleted(String namespace, Ingress ingress) {
        String ingressName = this.ingressName(ingress);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            Ingress inner = (Ingress)((Resource)((NonNamespaceOperation)this.client.network().v1().ingresses().inNamespace(namespace)).withName(ingressName)).get();
            return inner == null;
        });
    }

    private void waitForDeploymentToBeDeleted(String namespace, Deployment deployment) {
        String deploymentName = this.deploymentName(deployment);
        Map matchLabels = deployment.getSpec().getSelector().getMatchLabels();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            Deployment inner = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
            return inner == null;
        });
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(60L, TimeUnit.SECONDS).until(() -> {
            List podList = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(matchLabels)).list()).getItems();
            return podList == null || podList.isEmpty();
        });
    }

    private void waitForDeployment(String namespace, Deployment deployment) {
        String deploymentName = this.deploymentName(deployment);
        Awaitility.await().pollInterval(Duration.ofSeconds(2L)).atMost(600L, TimeUnit.SECONDS).until(() -> this.isDeploymentReady(namespace, deploymentName));
    }

    private boolean isDeploymentReady(String namespace, String deploymentName) {
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
        Integer availableReplicas = deployment.getStatus().getAvailableReplicas();
        LOG.info((Object)("Available replicas for " + deploymentName + ": " + (availableReplicas == null ? 0 : 1)));
        return availableReplicas != null && availableReplicas >= 1;
    }

    public void waitForIngress(String namespace, Ingress ingress) {
        String ingressName = this.ingressName(ingress);
        try {
            Awaitility.await().pollInterval(Duration.ofSeconds(2L)).atMost(180L, TimeUnit.SECONDS).until(() -> {
                Ingress inner = (Ingress)((Resource)((NonNamespaceOperation)this.client.network().v1().ingresses().inNamespace(namespace)).withName(ingressName)).get();
                if (inner == null) {
                    LOG.info((Object)("ingress : " + ingressName + " not ready yet present"));
                    return false;
                }
                List loadBalancerIngress = inner.getStatus().getLoadBalancer().getIngress();
                if (loadBalancerIngress == null || loadBalancerIngress.isEmpty()) {
                    LOG.info((Object)("ingress : " + ingressName + " not ready yet (loadbalancer ingress not yet present)"));
                    return false;
                }
                String ip = ((LoadBalancerIngress)loadBalancerIngress.get(0)).getIp();
                if (ip == null) {
                    LOG.info((Object)("ingress : " + ingressName + " not ready yet"));
                    return false;
                }
                LOG.info((Object)("ingress : " + ingressName + " ready with ip : " + ip));
                return true;
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Error waiting for ingress");
            e.printStackTrace();
        }
    }

    public void patchWithReplace(String imageName, String deploymentName, String namespace, String patchBody, Map<String, String> labels) {
        String body = patchBody.replace("image_name_here", imageName);
        ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).patch(PatchContext.of((PatchType)PatchType.JSON_MERGE), body);
        this.waitForDeploymentAfterPatch(deploymentName, namespace, labels);
    }

    private void waitForDeploymentAfterPatch(String deploymentName, String namespace, Map<String, String> labels) {
        try {
            Awaitility.await().pollDelay(Duration.ofSeconds(4L)).pollInterval(Duration.ofSeconds(3L)).atMost(60L, TimeUnit.SECONDS).until(() -> this.isDeploymentReadyAfterPatch(deploymentName, namespace, labels));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isDeploymentReadyAfterPatch(String deploymentName, String namespace, Map<String, String> labels) {
        DeploymentList deployments = (DeploymentList)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).list();
        if (deployments.getItems().isEmpty()) {
            Assertions.fail((String)("No deployment with name " + deploymentName));
        }
        Deployment deployment = deployments.getItems().stream().filter(x -> x.getMetadata().getName().equals(deploymentName)).findFirst().orElseThrow();
        int replicas = Optional.ofNullable(deployment.getSpec().getReplicas()).orElse(1);
        int numberOfPods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(labels)).list()).getItems().size();
        if (numberOfPods != replicas) {
            LOG.info((Object)"number of pods not yet stabilized");
            return false;
        }
        return replicas == Optional.ofNullable(deployment.getStatus().getReadyReplicas()).orElse(0);
    }

    private void innerSetup(String namespace, InputStream serviceAccountAsStream, InputStream roleBindingAsStream, InputStream roleAsStream) {
        ServiceAccount serviceAccountFromStream = (ServiceAccount)((Resource)this.client.serviceAccounts().load(serviceAccountAsStream)).get();
        if (((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).withName(serviceAccountFromStream.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).resource((Object)serviceAccountFromStream)).create();
        }
        RoleBinding roleBindingFromStream = (RoleBinding)((Resource)this.client.rbac().roleBindings().load(roleBindingAsStream)).get();
        if (((Resource)((NonNamespaceOperation)this.client.rbac().roleBindings().inNamespace(namespace)).withName(roleBindingFromStream.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)this.client.rbac().roleBindings().inNamespace(namespace)).resource((Object)roleBindingFromStream)).create();
        }
        Role roleFromStream = (Role)((Resource)this.client.rbac().roles().load(roleAsStream)).get();
        if (((Resource)((NonNamespaceOperation)this.client.rbac().roles().inNamespace(namespace)).withName(roleFromStream.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)this.client.rbac().roles().inNamespace(namespace)).resource((Object)roleFromStream)).create();
        }
    }

    private String deploymentName(Deployment deployment) {
        return deployment.getMetadata().getName();
    }

    private String ingressName(Ingress ingress) {
        return ingress.getMetadata().getName();
    }

    private String configMapName(ConfigMap configMap) {
        return configMap.getMetadata().getName();
    }

    private String secretName(Secret secret) {
        return secret.getMetadata().getName();
    }

    public KubernetesClient client() {
        return this.client;
    }
}

