/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.apis.RbacAuthorizationV1Api;
import io.kubernetes.client.openapi.models.V1ClusterRole;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerFluent;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentBuilder;
import io.kubernetes.client.openapi.models.V1DeploymentFluent;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1DeploymentSpecFluent;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatus;
import io.kubernetes.client.openapi.models.V1PodSpecFluent;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluent;
import io.kubernetes.client.openapi.models.V1ProbeFluent;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1ReplicationControllerList;
import io.kubernetes.client.openapi.models.V1Role;
import io.kubernetes.client.openapi.models.V1RoleBinding;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1ServiceBuilder;
import io.kubernetes.client.openapi.models.V1ServiceFluent;
import io.kubernetes.client.openapi.models.V1ServiceSpecFluent;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Yaml;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.springframework.cloud.kubernetes.integration.tests.commons.Commons;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.testcontainers.k3s.K3sContainer;

public class K8SUtils {
    private static final String KUBERNETES_VERSION_FILE = "META-INF/springcloudkubernetes-version.txt";
    private static final String WIREMOCK_DEPLOYMENT_NAME = "servicea-wiremock-deployment";
    private static final String WIREMOCK_APP_NAME = "servicea-wiremock";
    private final Log log = LogFactory.getLog(this.getClass());
    private final CoreV1Api api;
    private final AppsV1Api appsApi;
    private final NetworkingV1Api networkingApi;
    private final RbacAuthorizationV1Api rbacApi;

    public static ApiClient createApiClient() throws IOException {
        return K8SUtils.createApiClient(false, Duration.ofSeconds(15L));
    }

    public static String getPomVersion() {
        String string;
        block9: {
            InputStream in = new ClassPathResource(KUBERNETES_VERSION_FILE).getInputStream();
            try {
                String version = StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (StringUtils.hasText((String)version)) {
                    version = version.trim();
                }
                string = version;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                    return null;
                }
            }
            in.close();
        }
        return string;
    }

    public static ApiClient createApiClient(boolean debug, Duration readTimeout) throws IOException {
        ApiClient client = Config.defaultClient();
        client.setHttpClient(client.getHttpClient().newBuilder().readTimeout(readTimeout).build());
        client.setDebugging(debug);
        Configuration.setDefaultApiClient((ApiClient)client);
        return client;
    }

    public static ApiClient createApiClient(String configFile) throws IOException {
        ApiClient client = Config.fromConfig((Reader)new StringReader(configFile));
        client.setHttpClient(client.getHttpClient().newBuilder().readTimeout(Duration.ofSeconds(15L)).build());
        client.setDebugging(false);
        Configuration.setDefaultApiClient((ApiClient)client);
        return client;
    }

    public K8SUtils(CoreV1Api api, AppsV1Api appsApi) {
        this.api = api;
        this.appsApi = appsApi;
        this.networkingApi = new NetworkingV1Api();
        this.rbacApi = new RbacAuthorizationV1Api();
    }

    public Object readYaml(String urlString) throws Exception {
        URL url = new URL(urlString);
        Object yamlObj = null;
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            yamlObj = Yaml.load((Reader)reader);
        }
        return yamlObj;
    }

    public static Object readYamlFromClasspath(String fileName) throws Exception {
        ClassLoader classLoader = K8SUtils.class.getClassLoader();
        String file = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(fileName))).lines().collect(Collectors.joining("\n"));
        return Yaml.load((String)file);
    }

    public V1Service createService(String name, Map<String, String> labels, Map<String, String> specSelectors, String type, String portName, int port, int targetPort, String namespace) throws ApiException {
        V1Service wiremockService = ((V1ServiceBuilder)((V1ServiceFluent.SpecNested)((V1ServiceSpecFluent.PortsNested)((V1ServiceSpecFluent.PortsNested)((V1ServiceSpecFluent.PortsNested)((V1ServiceFluent.SpecNested)((V1ServiceFluent.SpecNested)((V1ServiceBuilder)((V1ServiceFluent.MetadataNested)((V1ServiceFluent.MetadataNested)new V1ServiceBuilder().editOrNewMetadata().withName(name)).addToLabels(labels)).endMetadata()).editOrNewSpec().addToSelector(specSelectors)).withType(type)).addNewPort().withName(portName)).withPort(Integer.valueOf(port))).withNewTargetPort(targetPort)).endPort()).endSpec()).build();
        return this.api.createNamespacedService(namespace, wiremockService, null, null, null, null);
    }

    public V1Deployment createDeployment(String name, Map<String, String> selectorMatchLabels, Map<String, String> templateMetadataLabels, String containerName, String image, String pullPolicy, int containerPort, int readinessProbePort, String readinessProbePath, int livenessProbePort, String livenessProbePath, String serviceAccountName, Collection<V1EnvVar> envVars, String namespace) throws ApiException {
        V1Deployment wiremockDeployment = ((V1DeploymentBuilder)((V1DeploymentFluent.SpecNested)((V1DeploymentSpecFluent.TemplateNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.LivenessProbeNested)((V1ProbeFluent.HttpGetNested)((V1ProbeFluent.HttpGetNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.ReadinessProbeNested)((V1ProbeFluent.HttpGetNested)((V1ProbeFluent.HttpGetNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.PortsNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodTemplateSpecFluent.SpecNested)((V1DeploymentSpecFluent.TemplateNested)((V1PodTemplateSpecFluent.MetadataNested)((V1DeploymentFluent.SpecNested)((V1DeploymentSpecFluent.SelectorNested)((V1DeploymentBuilder)((V1DeploymentFluent.MetadataNested)new V1DeploymentBuilder().editOrNewMetadata().withName(name)).endMetadata()).editOrNewSpec().withNewSelector().addToMatchLabels(selectorMatchLabels)).endSelector()).editOrNewTemplate().editOrNewMetadata().addToLabels(templateMetadataLabels)).endMetadata()).editOrNewSpec().withServiceAccountName(serviceAccountName)).addNewContainer().withName(containerName)).withImage(image)).withImagePullPolicy(pullPolicy)).addNewPort().withContainerPort(Integer.valueOf(containerPort))).endPort()).editOrNewReadinessProbe().editOrNewHttpGet().withNewPort(readinessProbePort)).withPath(readinessProbePath)).endHttpGet()).endReadinessProbe()).editOrNewLivenessProbe().editOrNewHttpGet().withNewPort(livenessProbePort)).withPath(livenessProbePath)).endHttpGet()).endLivenessProbe()).addAllToEnv(envVars)).endContainer()).endSpec()).endTemplate()).endSpec()).build();
        return this.appsApi.createNamespacedDeployment(namespace, wiremockDeployment, null, null, null, null);
    }

    public void waitForEndpointReady(String name, String namespace) {
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> this.isEndpointReady(name, namespace));
    }

    public boolean isEndpointReady(String name, String namespace) throws ApiException {
        V1Endpoints endpoint;
        V1EndpointsList endpoints = this.api.listNamespacedEndpoints(namespace, null, null, null, "metadata.name=" + name, null, null, null, null, null, null);
        if (endpoints.getItems().isEmpty()) {
            Assert.fail((String)("no endpoints for " + name));
        }
        return ((V1EndpointSubset)(endpoint = (V1Endpoints)endpoints.getItems().get(0)).getSubsets().get(0)).getAddresses().size() >= 1;
    }

    public void waitForReplicationController(String name, String namespace) {
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> this.isReplicationControllerReady(name, namespace));
    }

    public boolean isReplicationControllerReady(String name, String namespace) throws ApiException {
        V1ReplicationController replicationController;
        Integer availableReplicas;
        V1ReplicationControllerList controllerList = this.api.listNamespacedReplicationController(namespace, null, null, null, "metadata.name=" + name, null, null, null, null, null, null);
        if (controllerList.getItems().size() < 1) {
            Assert.fail((String)("Replication controller with name " + name + "could not be found"));
        }
        this.log.info((Object)("Available replicas for " + name + ": " + ((availableReplicas = (replicationController = (V1ReplicationController)controllerList.getItems().get(0)).getStatus().getAvailableReplicas()) == null ? 0 : availableReplicas)));
        return availableReplicas != null && availableReplicas >= 1;
    }

    public void waitForDeployment(String deploymentName, String namespace) {
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> this.isDeploymentReady(deploymentName, namespace));
    }

    public void waitForIngress(String ingressName, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(90L)).pollInterval(Duration.ofSeconds(3L)).until(() -> {
            try {
                V1LoadBalancerStatus status = this.networkingApi.readNamespacedIngress(ingressName, namespace, null).getStatus().getLoadBalancer();
                if (status == null) {
                    this.log.info((Object)("ingress : " + ingressName + " not ready yet (loadbalancer not yet present)"));
                    return false;
                }
                List loadBalancerIngress = status.getIngress();
                if (loadBalancerIngress == null) {
                    this.log.info((Object)("ingress : " + ingressName + " not ready yet (loadbalancer ingress not yet present)"));
                    return false;
                }
                String ip = ((V1LoadBalancerIngress)loadBalancerIngress.get(0)).getIp();
                if (ip == null) {
                    this.log.info((Object)("ingress : " + ingressName + " not ready yet"));
                    return false;
                }
                this.log.info((Object)("ingress : " + ingressName + " ready with ip : " + ip));
                return true;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return false;
                }
                throw new RuntimeException(e);
            }
        });
    }

    public void waitForDeploymentToBeDeleted(String deploymentName, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(90L)).until(() -> {
            try {
                this.appsApi.readNamespacedDeployment(deploymentName, namespace, null);
                return false;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    public boolean isDeploymentReady(String deploymentName, String namespace) throws ApiException {
        V1Deployment deployment;
        Integer availableReplicas;
        V1DeploymentList deployments = this.appsApi.listNamespacedDeployment(namespace, null, null, null, "metadata.name=" + deploymentName, null, null, null, null, null, null);
        if (deployments.getItems().size() < 1) {
            Assert.fail((String)("No deployments with the name " + deploymentName));
        }
        this.log.info((Object)("Available replicas for " + deploymentName + ": " + ((availableReplicas = (deployment = (V1Deployment)deployments.getItems().get(0)).getStatus().getAvailableReplicas()) == null ? 0 : availableReplicas)));
        return availableReplicas != null && availableReplicas >= 1;
    }

    public void setUp(String namespace) throws Exception {
        V1ServiceAccount serviceAccount = K8SUtils.getConfigK8sClientItServiceAccount();
        CheckedSupplier<V1ServiceAccount> accountSupplier = () -> this.api.readNamespacedServiceAccount(serviceAccount.getMetadata().getName(), namespace, null);
        CheckedSupplier<V1ServiceAccount> accountDefaulter = () -> this.api.createNamespacedServiceAccount(namespace, serviceAccount, null, null, null, null);
        K8SUtils.notExistsHandler(accountSupplier, accountDefaulter);
        V1RoleBinding roleBinding = K8SUtils.getConfigK8sClientItRoleBinding();
        K8SUtils.notExistsHandler(() -> this.rbacApi.readNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace, null), () -> this.rbacApi.createNamespacedRoleBinding(namespace, roleBinding, null, null, null, null));
        V1Role role = K8SUtils.getConfigK8sClientItRole();
        K8SUtils.notExistsHandler(() -> this.rbacApi.readNamespacedRole(role.getMetadata().getName(), namespace, null), () -> this.rbacApi.createNamespacedRole(namespace, role, null, null, null, null));
    }

    public void deleteNamespace(String name) throws Exception {
        this.api.deleteNamespace(name, null, null, null, null, null, null);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> this.api.listNamespace(null, null, null, null, null, null, null, null, null, null).getItems().stream().noneMatch(x -> x.getMetadata().getName().equals(name)));
    }

    public void setUpClusterWide(String serviceAccountNamespace, Set<String> namespaces) throws Exception {
        V1ServiceAccount serviceAccount = K8SUtils.getConfigK8sClientItClusterServiceAccount();
        CheckedSupplier<V1ServiceAccount> accountSupplier = () -> this.api.readNamespacedServiceAccount(serviceAccount.getMetadata().getName(), serviceAccountNamespace, null);
        CheckedSupplier<V1ServiceAccount> accountDefaulter = () -> this.api.createNamespacedServiceAccount(serviceAccountNamespace, serviceAccount, null, null, null, null);
        K8SUtils.notExistsHandler(accountSupplier, accountDefaulter);
        V1ClusterRole clusterRole = K8SUtils.getConfigK8sClientItClusterRole();
        K8SUtils.notExistsHandler(() -> this.rbacApi.readClusterRole(clusterRole.getMetadata().getName(), null), () -> this.rbacApi.createClusterRole(clusterRole, null, null, null, null));
        V1RoleBinding roleBinding = K8SUtils.getConfigK8sClientItClusterRoleBinding();
        namespaces.forEach(namespace -> {
            roleBinding.getMetadata().setNamespace(namespace);
            try {
                K8SUtils.notExistsHandler(() -> this.rbacApi.readNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace, null), () -> this.rbacApi.createNamespacedRoleBinding(namespace, roleBinding, null, null, null, null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static V1ServiceAccount getConfigK8sClientItClusterServiceAccount() throws Exception {
        return (V1ServiceAccount)K8SUtils.readYamlFromClasspath("cluster/service-account.yaml");
    }

    public static V1ClusterRole getConfigK8sClientItClusterRole() throws Exception {
        return (V1ClusterRole)K8SUtils.readYamlFromClasspath("cluster/cluster-role.yaml");
    }

    public static V1RoleBinding getConfigK8sClientItClusterRoleBinding() throws Exception {
        return (V1RoleBinding)K8SUtils.readYamlFromClasspath("cluster/role-binding.yaml");
    }

    public static V1ServiceAccount getConfigK8sClientItServiceAccount() throws Exception {
        return (V1ServiceAccount)K8SUtils.readYamlFromClasspath("setup/service-account.yaml");
    }

    public static V1RoleBinding getConfigK8sClientItRoleBinding() throws Exception {
        return (V1RoleBinding)K8SUtils.readYamlFromClasspath("setup/role-binding.yaml");
    }

    public static V1Role getConfigK8sClientItRole() throws Exception {
        return (V1Role)K8SUtils.readYamlFromClasspath("setup/role.yaml");
    }

    public void deployWiremock(String namespace, boolean rootPath, K3sContainer container) throws Exception {
        this.innerDeployWiremock(namespace, rootPath, container);
        this.waitForDeployment(WIREMOCK_DEPLOYMENT_NAME, namespace);
        this.waitForEndpointReady(WIREMOCK_APP_NAME, namespace);
    }

    public void cleanUpWiremock(String namespace) throws Exception {
        this.appsApi.deleteCollectionNamespacedDeployment(namespace, null, null, null, "metadata.name=servicea-wiremock-deployment", null, null, null, null, null, null, null, null, null);
        this.api.deleteNamespacedService(WIREMOCK_APP_NAME, namespace, null, null, null, null, null, null);
        this.networkingApi.deleteNamespacedIngress("wiremock-ingress", namespace, null, null, null, null, null, null);
        this.waitForDeploymentToBeDeleted(WIREMOCK_DEPLOYMENT_NAME, namespace);
    }

    public void removeWiremockImage() throws Exception {
        V1Deployment wiremockDeployment = K8SUtils.getWiremockDeployment();
        String wiremockImage = K8SUtils.getImageFromDeployment(wiremockDeployment);
        Commons.cleanUpDownloadedImage(wiremockImage);
    }

    public static String getImageFromDeployment(V1Deployment deployment) {
        return ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
    }

    public static String getImageFromDeployment(Deployment deployment) {
        return ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
    }

    private void innerDeployWiremock(String namespace, boolean rootPath, K3sContainer container) throws Exception {
        V1Deployment deployment = K8SUtils.getWiremockDeployment();
        String[] image = K8SUtils.getImageFromDeployment(deployment).split(":", 2);
        Commons.pullImage(image[0], image[1], container);
        Commons.loadImage(image[0], image[1], "wiremock", container);
        this.appsApi.createNamespacedDeployment(namespace, K8SUtils.getWiremockDeployment(), null, null, null, null);
        this.api.createNamespacedService(namespace, K8SUtils.getWiremockAppService(), null, null, null, null);
        V1Ingress ingress = rootPath ? K8SUtils.getWiremockRootPathIngress() : K8SUtils.getWiremockIngress();
        this.networkingApi.createNamespacedIngress(namespace, ingress, null, null, null, null);
        this.waitForIngress(ingress.getMetadata().getName(), namespace);
    }

    private static V1Ingress getWiremockIngress() throws Exception {
        return (V1Ingress)K8SUtils.readYamlFromClasspath("wiremock/wiremock-ingress.yaml");
    }

    private static V1Ingress getWiremockRootPathIngress() throws Exception {
        return (V1Ingress)K8SUtils.readYamlFromClasspath("wiremock/wiremock-root-path-ingress.yaml");
    }

    private static V1Service getWiremockAppService() throws Exception {
        return (V1Service)K8SUtils.readYamlFromClasspath("wiremock/wiremock-service.yaml");
    }

    private static V1Deployment getWiremockDeployment() throws Exception {
        return (V1Deployment)K8SUtils.readYamlFromClasspath("wiremock/wiremock-deployment.yaml");
    }

    private static <T> void notExistsHandler(CheckedSupplier<T> callee, CheckedSupplier<T> defaulter) throws Exception {
        try {
            callee.get();
        }
        catch (Exception exception) {
            ApiException apiException;
            if (exception instanceof ApiException && (apiException = (ApiException)((Object)exception)).getCode() == 404) {
                defaulter.get();
                return;
            }
            throw new RuntimeException(exception);
        }
    }

    private static interface CheckedSupplier<T> {
        public T get() throws Exception;
    }
}

