/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;
import org.junit.Assert;

public final class Fabric8Utils {
    private static final Log LOG = LogFactory.getLog(Fabric8Utils.class);

    private Fabric8Utils() {
        throw new AssertionError((Object)"no instance provided");
    }

    public static InputStream inputStream(String fileName) {
        return Fabric8Utils.class.getClassLoader().getResourceAsStream(fileName);
    }

    public static void waitForDeployment(KubernetesClient client, String deploymentName, String namespace, int pollSeconds, int maxSeconds) {
        Awaitility.await().pollInterval(Duration.ofSeconds(pollSeconds)).atMost((long)maxSeconds, TimeUnit.SECONDS).until(() -> Fabric8Utils.isDeploymentReady(client, deploymentName, namespace));
    }

    public static void waitForEndpoint(KubernetesClient client, String endpointName, String namespace, int pollSeconds, int maxSeconds) {
        Awaitility.await().pollInterval(Duration.ofSeconds(pollSeconds)).atMost((long)maxSeconds, TimeUnit.SECONDS).until(() -> Fabric8Utils.isEndpointReady(client, endpointName, namespace));
    }

    private static boolean isDeploymentReady(KubernetesClient client, String deploymentName, String namespace) {
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
        Integer availableReplicas = deployment.getStatus().getAvailableReplicas();
        LOG.info((Object)("Available replicas for " + deploymentName + ": " + (availableReplicas == null ? 0 : 1)));
        return availableReplicas != null && availableReplicas >= 1;
    }

    private static boolean isEndpointReady(KubernetesClient client, String endpointName, String namespace) {
        Endpoints endpoint = (Endpoints)((Resource)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withName(endpointName)).get();
        if (endpoint.getSubsets().isEmpty()) {
            Assert.fail((String)("no endpoints for " + endpointName));
        }
        return ((EndpointSubset)endpoint.getSubsets().get(0)).getAddresses().size() >= 1;
    }

    public static void setUp(KubernetesClient client, String namespace) throws Exception {
        InputStream serviceAccountAsStream = Fabric8Utils.inputStream("setup/service-account.yaml");
        InputStream roleBindingAsStream = Fabric8Utils.inputStream("setup/role-binding.yaml");
        InputStream roleAsStream = Fabric8Utils.inputStream("setup/role.yaml");
        Fabric8Utils.innerSetup(client, namespace, serviceAccountAsStream, roleBindingAsStream, roleAsStream);
    }

    public static void setUpClusterWide(KubernetesClient client, String serviceAccountNamespace, Set<String> namespaces) {
        InputStream clusterRoleBindingAsStream = Fabric8Utils.inputStream("cluster/cluster-role.yaml");
        InputStream serviceAccountAsStream = Fabric8Utils.inputStream("cluster/service-account.yaml");
        InputStream roleBindingAsStream = Fabric8Utils.inputStream("cluster/role-binding.yaml");
        ClusterRole clusterRole = (ClusterRole)((Resource)client.rbac().clusterRoles().load(clusterRoleBindingAsStream)).get();
        if (((Resource)client.rbac().clusterRoles().withName(clusterRole.getMetadata().getName())).get() == null) {
            ((Resource)client.rbac().clusterRoles().resource((Object)clusterRole)).create();
        }
        ServiceAccount serviceAccountFromStream = (ServiceAccount)((Resource)client.serviceAccounts().load(serviceAccountAsStream)).get();
        serviceAccountFromStream.getMetadata().setNamespace(serviceAccountNamespace);
        if (((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(serviceAccountNamespace)).withName(serviceAccountFromStream.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(serviceAccountNamespace)).resource((Object)serviceAccountFromStream)).create();
        }
        RoleBinding roleBindingFromStream = (RoleBinding)((Resource)client.rbac().roleBindings().load(roleBindingAsStream)).get();
        namespaces.forEach(namespace -> {
            roleBindingFromStream.getMetadata().setNamespace(namespace);
            if (((Resource)((NonNamespaceOperation)client.rbac().roleBindings().inNamespace(namespace)).withName(roleBindingFromStream.getMetadata().getName())).get() == null) {
                ((Resource)((NonNamespaceOperation)client.rbac().roleBindings().inNamespace(namespace)).resource((Object)roleBindingFromStream)).create();
            }
        });
    }

    public static void cleanUpClusterWide(KubernetesClient client, String serviceAccountNamespace, Set<String> namespaces) {
        InputStream clusterRoleBindingAsStream = Fabric8Utils.inputStream("cluster/cluster-role.yaml");
        InputStream serviceAccountAsStream = Fabric8Utils.inputStream("cluster/service-account.yaml");
        InputStream roleBindingAsStream = Fabric8Utils.inputStream("cluster/role-binding.yaml");
        ClusterRole clusterRole = (ClusterRole)((Resource)client.rbac().clusterRoles().load(clusterRoleBindingAsStream)).get();
        ((Resource)client.rbac().clusterRoles().withName(clusterRole.getMetadata().getName())).delete();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            ClusterRole innerClusterRole = (ClusterRole)((Resource)client.rbac().clusterRoles().withName(clusterRole.getMetadata().getName())).get();
            return innerClusterRole == null;
        });
        ServiceAccount serviceAccount = (ServiceAccount)((Resource)client.serviceAccounts().load(serviceAccountAsStream)).get();
        ((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(serviceAccountNamespace)).withName(serviceAccount.getMetadata().getName())).delete();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            ServiceAccount innerServiceAccount = (ServiceAccount)((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(serviceAccountNamespace)).withName(serviceAccount.getMetadata().getName())).get();
            return innerServiceAccount == null;
        });
        RoleBinding roleBinding = (RoleBinding)((Resource)client.rbac().roleBindings().load(roleBindingAsStream)).get();
        namespaces.forEach(namespace -> {
            ((Resource)((NonNamespaceOperation)client.rbac().roleBindings().inNamespace(namespace)).withName(roleBinding.getMetadata().getName())).delete();
            Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
                RoleBinding innerRoleBinding = (RoleBinding)((Resource)((NonNamespaceOperation)client.rbac().roleBindings().inNamespace(namespace)).withName(roleBinding.getMetadata().getName())).get();
                return innerRoleBinding == null;
            });
        });
    }

    public static void setUpIstio(KubernetesClient client, String namespace) {
        InputStream serviceAccountAsStream = Fabric8Utils.inputStream("istio/service-account.yaml");
        InputStream roleBindingAsStream = Fabric8Utils.inputStream("istio/role-binding.yaml");
        InputStream roleAsStream = Fabric8Utils.inputStream("istio/role.yaml");
        Fabric8Utils.innerSetup(client, namespace, serviceAccountAsStream, roleBindingAsStream, roleAsStream);
    }

    public static void waitForIngress(KubernetesClient client, String ingressName, String namespace) {
        try {
            Awaitility.await().pollInterval(Duration.ofSeconds(2L)).atMost(180L, TimeUnit.SECONDS).until(() -> {
                Ingress ingress = (Ingress)((Resource)((NonNamespaceOperation)client.network().v1().ingresses().inNamespace(namespace)).withName(ingressName)).get();
                if (ingress == null) {
                    System.out.println("ingress : " + ingressName + " not ready yet present");
                    return false;
                }
                List loadBalancerIngress = ingress.getStatus().getLoadBalancer().getIngress();
                if (loadBalancerIngress == null || loadBalancerIngress.isEmpty()) {
                    System.out.println("ingress : " + ingressName + " not ready yet (loadbalancer ingress not yet present)");
                    return false;
                }
                String ip = ((LoadBalancerIngress)loadBalancerIngress.get(0)).getIp();
                if (ip == null) {
                    System.out.println("ingress : " + ingressName + " not ready yet");
                    return false;
                }
                System.out.println("ingress : " + ingressName + " ready with ip : " + ip);
                return true;
            });
        }
        catch (Exception e) {
            System.out.println("Error waiting for ingress");
            e.printStackTrace();
        }
    }

    public static void waitForConfigMapDelete(KubernetesClient client, String namespace, String name) {
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name)).get();
            return configMap == null;
        });
    }

    public static void deleteDeployment(KubernetesClient client, String namespace, String name) {
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withName(name)).get();
        Map matchLabels = deployment.getSpec().getSelector().getMatchLabels();
        ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).resource((Object)deployment)).delete();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            Deployment inner = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).withName(name)).get();
            return inner == null;
        });
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(60L, TimeUnit.SECONDS).until(() -> {
            List podList = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withLabels(matchLabels)).list()).getItems();
            return podList == null || podList.isEmpty();
        });
    }

    public static void deleteService(KubernetesClient client, String namespace, String name) {
        ((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).withName(name)).delete();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            Service service = (Service)((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).withName(name)).get();
            return service == null;
        });
    }

    public static void deleteIngress(KubernetesClient client, String namespace, String name) {
        ((Resource)((NonNamespaceOperation)client.network().v1().ingresses().inNamespace(namespace)).withName(name)).delete();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            Ingress ingress = (Ingress)((Resource)((NonNamespaceOperation)client.network().v1().ingresses().inNamespace(namespace)).withName(name)).get();
            return ingress == null;
        });
    }

    public static void deleteNamespace(KubernetesClient client, String name) {
        ((Resource)client.namespaces().withName(name)).delete();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            Namespace namespace = (Namespace)((Resource)client.namespaces().withName(name)).get();
            return namespace == null;
        });
    }

    private static void innerSetup(KubernetesClient client, String namespace, InputStream serviceAccountAsStream, InputStream roleBindingAsStream, InputStream roleAsStream) {
        ServiceAccount serviceAccountFromStream = (ServiceAccount)((Resource)client.serviceAccounts().load(serviceAccountAsStream)).get();
        if (((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(namespace)).withName(serviceAccountFromStream.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(namespace)).resource((Object)serviceAccountFromStream)).create();
        }
        RoleBinding roleBindingFromStream = (RoleBinding)((Resource)client.rbac().roleBindings().load(roleBindingAsStream)).get();
        if (((Resource)((NonNamespaceOperation)client.rbac().roleBindings().inNamespace(namespace)).withName(roleBindingFromStream.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)client.rbac().roleBindings().inNamespace(namespace)).resource((Object)roleBindingFromStream)).create();
        }
        Role roleFromStream = (Role)((Resource)client.rbac().roles().load(roleAsStream)).get();
        if (((Resource)((NonNamespaceOperation)client.rbac().roles().inNamespace(namespace)).withName(roleFromStream.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)client.rbac().roles().inNamespace(namespace)).resource((Object)roleFromStream)).create();
        }
    }
}

