/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons;

import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.kubernetes.integration.tests.commons.K8SUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.k3s.K3sContainer;
import org.testcontainers.utility.DockerImageName;

public final class Commons {
    public static final String RANCHER = "rancher/k3s:v1.25.4-k3s1";
    public static final String RANCHER_COMMAND = "server";
    public static final int[] EXPOSED_PORTS = new int[]{80, 6443, 8080, 8888, 9092};
    public static final String TEMP_FOLDER = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
    private static final K3sContainer CONTAINER = (K3sContainer)((K3sContainer)((K3sContainer)new FixedPortsK3sContainer(DockerImageName.parse((String)"rancher/k3s:v1.25.4-k3s1")).configureFixedPorts(EXPOSED_PORTS).withFileSystemBind(TEMP_FOLDER, TEMP_FOLDER)).withCommand("server")).withReuse(true);

    private Commons() {
        throw new AssertionError((Object)"No instance provided");
    }

    public static K3sContainer container() {
        return CONTAINER;
    }

    public static void loadSpringCloudKubernetesImage(String project, K3sContainer container) throws Exception {
        Commons.loadImage("springcloud/" + project, K8SUtils.getPomVersion(), project, container);
    }

    public static void loadImage(String image, String tag, String tarName, K3sContainer container) throws Exception {
        try (SaveImageCmd saveImageCmd = container.getDockerClient().saveImageCmd(image);){
            InputStream imageStream = saveImageCmd.withTag(tag).exec();
            Path imagePath = Paths.get(TEMP_FOLDER + "/" + tarName + ".tar", new String[0]);
            Files.deleteIfExists(imagePath);
            Files.copy(imageStream, imagePath, new CopyOption[0]);
            container.execInContainer(new String[]{"ctr", "i", "import", TEMP_FOLDER + "/" + tarName + ".tar"});
        }
    }

    public static void cleanUp(String image, K3sContainer container) throws Exception {
        container.execInContainer(new String[]{"crictl", "rmi", "docker.io/springcloud/" + image + ":" + K8SUtils.getPomVersion()});
        container.execInContainer(new String[]{"rm", TEMP_FOLDER + "/" + image + ".tar"});
    }

    public static void cleanUpDownloadedImage(String image) throws Exception {
        CONTAINER.execInContainer(new String[]{"crictl", "rmi", image});
    }

    public static void validateImage(String image, K3sContainer container) {
        try (ListImagesCmd listImagesCmd = container.getDockerClient().listImagesCmd();){
            List images = (List)listImagesCmd.exec();
            images.stream().filter(x -> Arrays.stream(x.getRepoTags() == null ? new String[]{} : x.getRepoTags()).anyMatch(y -> y.contains(image))).findFirst().orElseThrow(() -> new IllegalArgumentException("Image : " + image + " not build locally. You need to build it first, and then run the test"));
        }
    }

    public static void pullImage(String image, String tag, K3sContainer container) throws InterruptedException {
        try (PullImageCmd pullImageCmd = container.getDockerClient().pullImageCmd(image);){
            pullImageCmd.withTag(tag).start().awaitCompletion();
        }
    }

    public static String processExecResult(Container.ExecResult execResult) {
        if (execResult.getExitCode() != 0) {
            throw new RuntimeException("stdout=" + execResult.getStdout() + "\nstderr=" + execResult.getStderr());
        }
        return execResult.getStdout();
    }

    private static final class FixedPortsK3sContainer
    extends K3sContainer {
        private FixedPortsK3sContainer(DockerImageName dockerImageName) {
            super(dockerImageName);
        }

        private FixedPortsK3sContainer configureFixedPorts(int[] ports) {
            for (int port : ports) {
                super.addFixedExposedPort(port, port);
            }
            return this;
        }
    }
}

