/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ContainerFluent;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentBuilder;
import io.kubernetes.client.openapi.models.V1DeploymentFluent;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1DeploymentSpecFluent;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1PodSpecFluent;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluent;
import io.kubernetes.client.openapi.models.V1ProbeFluent;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1ReplicationControllerList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceBuilder;
import io.kubernetes.client.openapi.models.V1ServiceFluent;
import io.kubernetes.client.openapi.models.V1ServiceSpecFluent;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Yaml;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class K8SUtils {
    private static final String KUBERNETES_VERSION_FILE = "META-INF/springcloudkubernetes-version.txt";
    private Log log = LogFactory.getLog(this.getClass());
    private CoreV1Api api;
    private AppsV1Api appsApi;

    public static ApiClient createApiClient() throws IOException {
        return K8SUtils.createApiClient(false, Duration.ofSeconds(15L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPomVersion() {
        try (InputStream in = new ClassPathResource(KUBERNETES_VERSION_FILE).getInputStream();){
            String version = StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.hasText((String)version)) {
                version = version.trim();
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
            return null;
        }
    }

    public static ApiClient createApiClient(boolean debug, Duration readTimeout) throws IOException {
        ApiClient client = Config.defaultClient();
        client.setHttpClient(client.getHttpClient().newBuilder().readTimeout(readTimeout).build());
        client.setDebugging(debug);
        Configuration.setDefaultApiClient((ApiClient)client);
        return client;
    }

    public K8SUtils(CoreV1Api api, AppsV1Api appsApi) {
        this.api = api;
        this.appsApi = appsApi;
    }

    public Object readYaml(String urlString) throws Exception {
        URL url = new URL(urlString);
        Object yamlObj = null;
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            yamlObj = Yaml.load((Reader)reader);
        }
        return yamlObj;
    }

    public Object readYamlFromClasspath(String fileName) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        File file = new File(classLoader.getResource(fileName).getFile());
        return Yaml.load((File)file);
    }

    public V1Service createService(String name, Map<String, String> labels, Map<String, String> specSelectors, String type, String portName, int port, int targetPort, String namespace) throws ApiException {
        V1Service wiremockService = ((V1ServiceBuilder)((V1ServiceFluent.SpecNested)((V1ServiceSpecFluent.PortsNested)((V1ServiceSpecFluent.PortsNested)((V1ServiceSpecFluent.PortsNested)((V1ServiceFluent.SpecNested)((V1ServiceFluent.SpecNested)((V1ServiceBuilder)((V1ServiceFluent.MetadataNested)((V1ServiceFluent.MetadataNested)new V1ServiceBuilder().editOrNewMetadata().withName(name)).addToLabels(labels)).endMetadata()).editOrNewSpec().addToSelector(specSelectors)).withNewType(type)).addNewPort().withName(portName)).withPort(Integer.valueOf(port))).withNewTargetPort(targetPort)).endPort()).endSpec()).build();
        return this.api.createNamespacedService(namespace, wiremockService, null, null, null);
    }

    public V1Deployment createDeployment(String name, Map<String, String> selectorMatchLabels, Map<String, String> templateMetadataLabels, String containerName, String image, String pullPolicy, int containerPort, int readinessProbePort, String readinessProbePath, int livenessProbePort, String livenessProbePath, String serviceAccountName, Collection<V1EnvVar> envVars, String namespace) throws ApiException {
        V1Deployment wiremockDeployment = ((V1DeploymentBuilder)((V1DeploymentFluent.SpecNested)((V1DeploymentSpecFluent.TemplateNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.LivenessProbeNested)((V1ProbeFluent.HttpGetNested)((V1ProbeFluent.HttpGetNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.ReadinessProbeNested)((V1ProbeFluent.HttpGetNested)((V1ProbeFluent.HttpGetNested)((V1PodSpecFluent.ContainersNested)((V1ContainerFluent.PortsNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodSpecFluent.ContainersNested)((V1PodTemplateSpecFluent.SpecNested)((V1DeploymentSpecFluent.TemplateNested)((V1PodTemplateSpecFluent.MetadataNested)((V1DeploymentFluent.SpecNested)((V1DeploymentSpecFluent.SelectorNested)((V1DeploymentBuilder)((V1DeploymentFluent.MetadataNested)new V1DeploymentBuilder().editOrNewMetadata().withName(name)).endMetadata()).editOrNewSpec().withNewSelector().addToMatchLabels(selectorMatchLabels)).endSelector()).editOrNewTemplate().editOrNewMetadata().addToLabels(templateMetadataLabels)).endMetadata()).editOrNewSpec().withServiceAccountName(serviceAccountName)).addNewContainer().withName(containerName)).withImage(image)).withImagePullPolicy(pullPolicy)).addNewPort().withContainerPort(Integer.valueOf(containerPort))).endPort()).editOrNewReadinessProbe().editOrNewHttpGet().withNewPort(readinessProbePort)).withNewPath(readinessProbePath)).endHttpGet()).endReadinessProbe()).editOrNewLivenessProbe().editOrNewHttpGet().withNewPort(livenessProbePort)).withNewPath(livenessProbePath)).endHttpGet()).endLivenessProbe()).addAllToEnv(envVars)).endContainer()).endSpec()).endTemplate()).endSpec()).build();
        return this.appsApi.createNamespacedDeployment(namespace, wiremockDeployment, null, null, null);
    }

    public void waitForEndpointReady(String name, String namespace) throws Exception {
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> this.isEndpointReady(name, namespace));
    }

    public boolean isEndpointReady(String name, String namespace) throws ApiException {
        V1Endpoints endpoint;
        V1EndpointsList endpoints = this.api.listNamespacedEndpoints(namespace, null, null, null, "metadata.name=" + name, null, null, null, null, null, null);
        if (endpoints.getItems().isEmpty()) {
            Assert.fail((String)("no endpoints for " + name));
        }
        return ((V1EndpointSubset)(endpoint = (V1Endpoints)endpoints.getItems().get(0)).getSubsets().get(0)).getAddresses().size() >= 1;
    }

    public void waitForReplicationController(String name, String namespace) {
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> this.isReplicationControllerReady(name, namespace));
    }

    public boolean isReplicationControllerReady(String name, String namespace) throws ApiException {
        V1ReplicationControllerList controllerList = this.api.listNamespacedReplicationController(namespace, null, null, null, "metadata.name=" + name, null, null, null, null, null, null);
        if (controllerList.getItems().size() < 1) {
            Assert.fail((String)("Replication controller with name " + name + "could not be found"));
        }
        V1ReplicationController replicationController = (V1ReplicationController)controllerList.getItems().get(0);
        Integer availableReplicas = replicationController.getStatus().getAvailableReplicas();
        this.log.info((Object)("Available replicas for " + name + ": " + availableReplicas));
        return availableReplicas != null && availableReplicas >= 1;
    }

    public void waitForDeployment(String deploymentName, String namespace) {
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> this.isDeployentReady(deploymentName, namespace));
    }

    public void waitForDeploymentToBeDeleted(String deploymentName, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(90L)).until(() -> {
            try {
                this.appsApi.readNamespacedDeployment(deploymentName, namespace, null, null, null);
                return false;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    public boolean isDeployentReady(String deploymentName, String namespace) throws ApiException {
        V1DeploymentList deployments = this.appsApi.listNamespacedDeployment(namespace, null, null, null, "metadata.name=" + deploymentName, null, null, null, null, null, null);
        if (deployments.getItems().size() < 1) {
            Assert.fail((String)("No deployments with the name " + deploymentName));
        }
        V1Deployment deployment = (V1Deployment)deployments.getItems().get(0);
        Integer availableReplicas = deployment.getStatus().getAvailableReplicas();
        this.log.info((Object)("Available replicas for " + deploymentName + ": " + availableReplicas));
        return availableReplicas != null && availableReplicas >= 1;
    }
}

