/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.leader.election;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;

final class Fabric8LeaderElectionInfoContributor
implements InfoContributor {
    private final String candidateIdentity;
    private final LeaderElectionConfig leaderElectionConfig;
    private final KubernetesClient fabric8KubernetesClient;

    Fabric8LeaderElectionInfoContributor(String candidateIdentity, LeaderElectionConfig leaderElectionConfig, KubernetesClient fabric8KubernetesClient) {
        this.candidateIdentity = candidateIdentity;
        this.leaderElectionConfig = leaderElectionConfig;
        this.fabric8KubernetesClient = fabric8KubernetesClient;
    }

    public void contribute(Info.Builder builder) {
        HashMap details = new HashMap();
        Optional.ofNullable(this.leaderElectionConfig.getLock().get(this.fabric8KubernetesClient)).ifPresentOrElse(leaderRecord -> {
            boolean isLeader = this.candidateIdentity.equals(leaderRecord.getHolderIdentity());
            details.put("leaderId", this.candidateIdentity);
            details.put("isLeader", isLeader);
        }, () -> details.put("leaderId", "Unknown"));
        builder.withDetail("leaderElection", details);
    }
}

