/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.leader.election;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.leader.election.ConditionalOnLeaderElectionEnabled;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionCallbacks;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.leader.election.Fabric8LeaderElectionCallbacks;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LeaderElectionProperties.class})
@ConditionalOnBean(value={KubernetesClient.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnLeaderElectionEnabled
@AutoConfigureAfter(value={Fabric8AutoConfiguration.class, KubernetesCommonsAutoConfiguration.class})
public class Fabric8LeaderElectionCallbacksAutoConfiguration
extends LeaderElectionCallbacks {
    @Bean
    @ConditionalOnMissingBean
    Fabric8LeaderElectionCallbacks fabric8LeaderElectionCallbacks(Runnable onStartLeadingCallback, Runnable onStopLeadingCallback, Consumer<String> onNewLeaderCallback) {
        return new Fabric8LeaderElectionCallbacks(onStartLeadingCallback, onStopLeadingCallback, onNewLeaderCallback);
    }
}

