/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.leader;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.net.UnknownHostException;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.leader.LeaderInfoContributor;
import org.springframework.cloud.kubernetes.commons.leader.LeaderInitiator;
import org.springframework.cloud.kubernetes.commons.leader.LeaderProperties;
import org.springframework.cloud.kubernetes.commons.leader.LeaderRecordWatcher;
import org.springframework.cloud.kubernetes.commons.leader.LeaderUtils;
import org.springframework.cloud.kubernetes.commons.leader.LeadershipController;
import org.springframework.cloud.kubernetes.commons.leader.PodReadinessWatcher;
import org.springframework.cloud.kubernetes.commons.leader.election.ConditionalOnLeaderElectionDisabled;
import org.springframework.cloud.kubernetes.fabric8.leader.Fabric8LeaderRecordWatcher;
import org.springframework.cloud.kubernetes.fabric8.leader.Fabric8LeadershipController;
import org.springframework.cloud.kubernetes.fabric8.leader.Fabric8PodReadinessWatcher;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.leader.event.DefaultLeaderEventPublisher;
import org.springframework.integration.leader.event.LeaderEventPublisher;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LeaderProperties.class})
@ConditionalOnBean(value={KubernetesClient.class})
@ConditionalOnProperty(value={"spring.cloud.kubernetes.leader.enabled"}, matchIfMissing=true)
@ConditionalOnLeaderElectionDisabled
public class Fabric8LeaderAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LeaderEventPublisher.class})
    public LeaderEventPublisher defaultLeaderEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        return new DefaultLeaderEventPublisher(applicationEventPublisher);
    }

    @Bean
    public Candidate candidate(LeaderProperties leaderProperties) throws UnknownHostException {
        String id = LeaderUtils.hostName();
        String role = leaderProperties.getRole();
        return new DefaultCandidate(id, role);
    }

    @Bean
    @ConditionalOnClass(value={InfoContributor.class})
    @ConditionalOnEnabledInfoContributor(value="leader")
    public LeaderInfoContributor leaderInfoContributor(Fabric8LeadershipController fabric8LeadershipController, Candidate candidate) {
        return new LeaderInfoContributor((LeadershipController)fabric8LeadershipController, candidate);
    }

    @Bean
    public Fabric8PodReadinessWatcher hostPodWatcher(Candidate candidate, KubernetesClient kubernetesClient, Fabric8LeadershipController fabric8LeadershipController) {
        return new Fabric8PodReadinessWatcher(candidate.getId(), kubernetesClient, fabric8LeadershipController);
    }

    @Bean
    public Fabric8LeadershipController leadershipController(Candidate candidate, LeaderProperties leaderProperties, LeaderEventPublisher leaderEventPublisher, KubernetesClient kubernetesClient) {
        return new Fabric8LeadershipController(candidate, leaderProperties, leaderEventPublisher, kubernetesClient);
    }

    @Bean
    public Fabric8LeaderRecordWatcher leaderRecordWatcher(LeaderProperties leaderProperties, Fabric8LeadershipController fabric8LeadershipController, KubernetesClient kubernetesClient) {
        return new Fabric8LeaderRecordWatcher(leaderProperties, fabric8LeadershipController, kubernetesClient);
    }

    @Bean
    public LeaderInitiator leaderInitiator(LeaderProperties leaderProperties, Fabric8LeadershipController fabric8LeadershipController, Fabric8LeaderRecordWatcher fabric8LeaderRecordWatcher, Fabric8PodReadinessWatcher hostPodWatcher) {
        return new LeaderInitiator(leaderProperties, (LeadershipController)fabric8LeadershipController, (LeaderRecordWatcher)fabric8LeaderRecordWatcher, (PodReadinessWatcher)hostPodWatcher);
    }
}

