/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.client.istio.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.cloud.kubernetes.fabric8.client.istio.IstioClientProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class MeshUtils {
    private static final Log LOG = LogFactory.getLog(MeshUtils.class);
    private final IstioClientProperties istioClientProperties;
    private final RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();

    public MeshUtils(IstioClientProperties istioClientProperties) {
        this.istioClientProperties = istioClientProperties;
    }

    public Boolean isIstioEnabled() {
        return this.checkIstioServices();
    }

    private synchronized boolean checkIstioServices() {
        try {
            String resource = "http://localhost:" + this.istioClientProperties.getEnvoyPort();
            ResponseEntity response = this.restTemplate.getForEntity(resource + "/" + this.istioClientProperties.getTestPath(), String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                LOG.info((Object)"Istio Resources Found.");
                return true;
            }
            LOG.warn((Object)("Although Envoy proxy did respond at port" + this.istioClientProperties.getEnvoyPort() + ", it did not respond with HTTP 200 to path: " + this.istioClientProperties.getTestPath() + ". You may need to tweak the test path in order to get proper Istio support"));
            return false;
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Envoy proxy could not be located at port: " + this.istioClientProperties.getEnvoyPort() + ". Assuming that the application is not running inside the Istio Service Mesh"));
            }
            return false;
        }
    }
}

