/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.istio;

import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.fabric8.istio.IstioClientProperties;
import org.springframework.cloud.kubernetes.fabric8.istio.utils.MeshUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.istio.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={IstioClientProperties.class})
public class IstioBootstrapConfiguration {
    private static final Log LOG = LogFactory.getLog(IstioBootstrapConfiguration.class);
    private static final String ISTIO_PROFILE = "istio";

    @Bean
    @ConditionalOnMissingBean
    public MeshUtils istioMeshUtils(IstioClientProperties istioClientProperties) {
        return new MeshUtils(istioClientProperties);
    }

    @EnableConfigurationProperties(value={IstioClientProperties.class})
    protected static class IstioDetectionConfiguration {
        private final MeshUtils utils;
        private final ConfigurableEnvironment environment;

        public IstioDetectionConfiguration(MeshUtils utils, ConfigurableEnvironment environment) {
            this.utils = utils;
            this.environment = environment;
        }

        @PostConstruct
        public void detectIstio() {
            this.addIstioProfile(this.environment);
        }

        void addIstioProfile(ConfigurableEnvironment environment) {
            if (this.utils.isIstioEnabled().booleanValue()) {
                if (this.hasIstioProfile((Environment)environment)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"'istio' already in list of active profiles");
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Adding 'istio' to list of active profiles");
                    }
                    environment.addActiveProfile(IstioBootstrapConfiguration.ISTIO_PROFILE);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Not running inside kubernetes with istio enabled. Skipping 'istio' profile activation.");
            }
        }

        private boolean hasIstioProfile(Environment environment) {
            return Arrays.stream(environment.getActiveProfiles()).anyMatch(IstioBootstrapConfiguration.ISTIO_PROFILE::equalsIgnoreCase);
        }
    }
}

