/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import java.util.Objects;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8AbstractReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClient;
import reactor.core.publisher.Flux;

public class Fabric8CacheableReactiveDiscoveryClient
extends Fabric8AbstractReactiveDiscoveryClient {
    Fabric8CacheableReactiveDiscoveryClient(Fabric8DiscoveryClient fabric8DiscoveryClient) {
        super(fabric8DiscoveryClient);
    }

    @Override
    @Cacheable(value={"fabric8-reactive-discovery-services"})
    public Flux<String> getServices() {
        return super.getServices();
    }

    @Override
    @Cacheable(value={"fabric8-reactive-discovery-instances"})
    public Flux<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId, "serviceId must not be null");
        return super.getInstances(serviceId);
    }

    @Override
    public String description() {
        return "Fabric8 Cacheable Reactive Discovery Client";
    }
}

