/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.discovery.v1.Endpoint;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8CatalogWatchContext;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClientUtils;

final class Fabric8EndpointSliceV1CatalogWatch
implements Function<Fabric8CatalogWatchContext, List<EndpointNameAndNamespace>> {
    Fabric8EndpointSliceV1CatalogWatch() {
    }

    @Override
    public List<EndpointNameAndNamespace> apply(Fabric8CatalogWatchContext context) {
        List<EndpointSlice> endpointSlices = Fabric8DiscoveryClientUtils.endpointSlices(context.properties(), context.kubernetesClient(), context.namespaceProvider(), "catalog-watcher");
        return this.generateState(endpointSlices);
    }

    List<EndpointNameAndNamespace> generateState(List<EndpointSlice> endpointSlices) {
        Stream<ObjectReference> references = endpointSlices.stream().map(EndpointSlice::getEndpoints).filter(Objects::nonNull).flatMap(Collection::stream).map(Endpoint::getTargetRef);
        return Fabric8CatalogWatchContext.state(references);
    }
}

