/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.DiscoveryClientUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.ServiceMetadata;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortNameAndNumber;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClientUtils;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8InstanceIdHostPodNameSupplier;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8PodLabelsAndAnnotationsSupplier;
import org.springframework.core.log.LogAccessor;

abstract class Fabric8AbstractBlockingDiscoveryClient
implements DiscoveryClient {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8AbstractBlockingDiscoveryClient.class));
    private final KubernetesDiscoveryProperties properties;
    private final ServicePortSecureResolver servicePortSecureResolver;
    private final KubernetesClient client;
    private final KubernetesNamespaceProvider namespaceProvider;
    private final Predicate<Service> predicate;

    Fabric8AbstractBlockingDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, ServicePortSecureResolver servicePortSecureResolver, KubernetesNamespaceProvider namespaceProvider, Predicate<Service> predicate) {
        this.client = client;
        this.properties = kubernetesDiscoveryProperties;
        this.servicePortSecureResolver = servicePortSecureResolver;
        this.namespaceProvider = namespaceProvider;
        this.predicate = predicate;
    }

    public abstract String description();

    public List<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId);
        List<Endpoints> allEndpoints = Fabric8DiscoveryClientUtils.endpoints(this.properties, this.client, this.namespaceProvider, "fabric8-discovery", serviceId, this.predicate);
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        for (Endpoints endpoints : allEndpoints) {
            instances.addAll(this.serviceInstances(endpoints, serviceId));
        }
        if (this.properties.includeExternalNameServices()) {
            LOG.debug(() -> "Searching for 'ExternalName' type of services with serviceId : " + serviceId);
            List<Service> services = Fabric8DiscoveryClientUtils.services(this.properties, this.client, this.namespaceProvider, s -> s.getSpec().getType().equals("ExternalName"), Map.of("metadata.name", serviceId), "fabric8-discovery");
            for (Service service : services) {
                ServiceMetadata serviceMetadata = Fabric8Utils.serviceMetadata((Service)service);
                Map serviceInstanceMetadata = DiscoveryClientUtils.serviceInstanceMetadata(Map.of(), (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
                Fabric8InstanceIdHostPodNameSupplier supplierOne = Fabric8InstanceIdHostPodNameSupplier.externalName(service);
                ServiceInstance externalNameServiceInstance = DiscoveryClientUtils.externalNameServiceInstance((ServiceMetadata)serviceMetadata, (Supplier)supplierOne, (Map)serviceInstanceMetadata);
                instances.add(externalNameServiceInstance);
            }
        }
        return instances;
    }

    public List<String> getServices() {
        List<String> services = Fabric8DiscoveryClientUtils.services(this.properties, this.client, this.namespaceProvider, this.predicate, null, "fabric8 discovery").stream().map(service -> service.getMetadata().getName()).distinct().toList();
        LOG.debug(() -> "will return services : " + String.valueOf(services));
        return services;
    }

    public int getOrder() {
        return this.properties.order();
    }

    private List<ServiceInstance> serviceInstances(Endpoints endpoints, String serviceId) {
        List subsets = endpoints.getSubsets();
        if (subsets.isEmpty()) {
            LOG.debug(() -> "serviceId : " + serviceId + " does not have any subsets");
            return List.of();
        }
        String namespace = endpoints.getMetadata().getNamespace();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceId)).get();
        ServiceMetadata serviceMetadata = Fabric8Utils.serviceMetadata((Service)service);
        Map<String, Integer> portsData = Fabric8DiscoveryClientUtils.endpointSubsetsPortData(subsets);
        Map serviceInstanceMetadata = DiscoveryClientUtils.serviceInstanceMetadata(portsData, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
        for (EndpointSubset endpointSubset : subsets) {
            Map<String, Integer> endpointsPortData = Fabric8DiscoveryClientUtils.endpointSubsetsPortData(List.of(endpointSubset));
            ServicePortNameAndNumber portData = DiscoveryClientUtils.endpointsPort(endpointsPortData, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
            List<EndpointAddress> addresses = Fabric8DiscoveryClientUtils.addresses(endpointSubset, this.properties);
            for (EndpointAddress endpointAddress : addresses) {
                Fabric8InstanceIdHostPodNameSupplier supplierOne = Fabric8InstanceIdHostPodNameSupplier.nonExternalName(endpointAddress, service);
                Fabric8PodLabelsAndAnnotationsSupplier supplierTwo = Fabric8PodLabelsAndAnnotationsSupplier.nonExternalName(this.client, namespace);
                ServiceInstance serviceInstance = DiscoveryClientUtils.serviceInstance((ServicePortSecureResolver)this.servicePortSecureResolver, (ServiceMetadata)serviceMetadata, (Supplier)supplierOne, (Function)supplierTwo, (ServicePortNameAndNumber)portData, (Map)serviceInstanceMetadata, (KubernetesDiscoveryProperties)this.properties);
                instances.add(serviceInstance);
            }
        }
        return instances;
    }
}

