/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerBootstrapper;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunctionProvider;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesDiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.ServicePortSecureResolver;
import org.springframework.util.ClassUtils;

class Fabric8ConfigServerBootstrapper
extends KubernetesConfigServerBootstrapper {
    Fabric8ConfigServerBootstrapper() {
    }

    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null)) {
            return;
        }
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, KubernetesFunction::create);
    }

    static final class KubernetesFunction
    implements ConfigServerInstanceProvider.Function {
        private final BootstrapContext context;

        private KubernetesFunction(BootstrapContext context) {
            this.context = context;
        }

        static KubernetesFunction create(BootstrapContext context) {
            return new KubernetesFunction(context);
        }

        public List<ServiceInstance> apply(String serviceId, Binder binder, BindHandler bindHandler, Log log) {
            if (binder == null || bindHandler == null || !KubernetesConfigServerBootstrapper.getDiscoveryEnabled((Binder)binder, (BindHandler)bindHandler).booleanValue()) {
                return Collections.emptyList();
            }
            KubernetesDiscoveryProperties discoveryProperties = KubernetesConfigServerBootstrapper.createKubernetesDiscoveryProperties((Binder)binder, (BindHandler)bindHandler);
            KubernetesClientProperties clientProperties = KubernetesConfigServerBootstrapper.createKubernetesClientProperties((Binder)binder, (BindHandler)bindHandler);
            return this.getInstanceProvider(discoveryProperties, clientProperties, this.context, binder, bindHandler).getInstances(serviceId);
        }

        private KubernetesConfigServerInstanceProvider getInstanceProvider(KubernetesDiscoveryProperties discoveryProperties, KubernetesClientProperties clientProperties, BootstrapContext context, Binder binder, BindHandler bindHandler) {
            if (context.isRegistered(KubernetesDiscoveryClient.class)) {
                KubernetesDiscoveryClient client = (KubernetesDiscoveryClient)context.get(KubernetesDiscoveryClient.class);
                return client::getInstances;
            }
            Fabric8AutoConfiguration fabric8AutoConfiguration = new Fabric8AutoConfiguration();
            Config config = fabric8AutoConfiguration.kubernetesClientConfig(clientProperties);
            KubernetesClient kubernetesClient = fabric8AutoConfiguration.kubernetesClient(config);
            KubernetesDiscoveryClient discoveryClient = new KubernetesDiscoveryClient(kubernetesClient, discoveryProperties, KubernetesClientServicesFunctionProvider.servicesFunction(discoveryProperties, binder, bindHandler), null, new ServicePortSecureResolver(discoveryProperties));
            return discoveryClient::getInstances;
        }

        public List<ServiceInstance> apply(String serviceId) {
            return this.apply(serviceId, null, null, null);
        }
    }
}

