/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnKubernetesDiscoveryEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunction;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunctionProvider;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesDiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.ServicePortSecureResolver;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnKubernetesDiscoveryEnabled
@ConditionalOnBlockingDiscoveryEnabled
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={Fabric8AutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class})
public class KubernetesDiscoveryClientAutoConfiguration {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesDiscoveryClientAutoConfiguration.class));

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClientServicesFunction servicesFunction(KubernetesDiscoveryProperties properties, Environment environment) {
        return KubernetesClientServicesFunctionProvider.servicesFunction(properties, environment);
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesDiscoveryClient kubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties, KubernetesClientServicesFunction kubernetesClientServicesFunction) {
        return new KubernetesDiscoveryClient(client, properties, kubernetesClientServicesFunction, null, new ServicePortSecureResolver(properties));
    }

    @Bean
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnDiscoveryHealthIndicatorEnabled
    public KubernetesDiscoveryClientHealthIndicatorInitializer indicatorInitializer(ApplicationEventPublisher applicationEventPublisher, PodUtils<?> podUtils) {
        LOG.debug(() -> "Will publish InstanceRegisteredEvent from blocking implementation");
        return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
    }
}

