/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.discovery.EndpointSubsetNS;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunction;
import org.springframework.cloud.kubernetes.fabric8.discovery.ServicePortSecureResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KubernetesDiscoveryClient
implements DiscoveryClient {
    private static final Log log = LogFactory.getLog(KubernetesDiscoveryClient.class);
    private final KubernetesDiscoveryProperties properties;
    private final ServicePortSecureResolver servicePortSecureResolver;
    private final KubernetesClientServicesFunction kubernetesClientServicesFunction;
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final SimpleEvaluationContext evalCtxt = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    private KubernetesClient client;

    public KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction) {
        this(client, kubernetesDiscoveryProperties, kubernetesClientServicesFunction, new ServicePortSecureResolver(kubernetesDiscoveryProperties));
    }

    KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction, ServicePortSecureResolver servicePortSecureResolver) {
        this.client = client;
        this.properties = kubernetesDiscoveryProperties;
        this.kubernetesClientServicesFunction = kubernetesClientServicesFunction;
        this.servicePortSecureResolver = servicePortSecureResolver;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public String description() {
        return "Kubernetes Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Assert.notNull((Object)serviceId, (String)"[Assertion failed] - the object argument must not be null");
        List subsetsNS = this.getEndPointsList(serviceId).stream().map(this::getSubsetsFromEndpoints).collect(Collectors.toList());
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        if (!subsetsNS.isEmpty()) {
            for (EndpointSubsetNS es : subsetsNS) {
                instances.addAll(this.getNamespaceServiceInstances(es, serviceId));
            }
        }
        return instances;
    }

    public List<Endpoints> getEndPointsList(String serviceId) {
        if (this.properties.allNamespaces()) {
            return ((EndpointsList)((FilterWatchListDeletable)((FilterWatchListDeletable)((AnyNamespaceOperation)this.client.endpoints().inAnyNamespace()).withField("metadata.name", serviceId)).withLabels(this.properties.serviceLabels())).list()).getItems();
        }
        if (this.properties.namespaces().isEmpty()) {
            return ((EndpointsList)((FilterWatchListDeletable)((FilterWatchListDeletable)this.client.endpoints().withField("metadata.name", serviceId)).withLabels(this.properties.serviceLabels())).list()).getItems();
        }
        return this.findEndPointsFilteredByNamespaces(serviceId);
    }

    private List<Endpoints> findEndPointsFilteredByNamespaces(String serviceId) {
        ArrayList<Endpoints> endpoints = new ArrayList<Endpoints>();
        for (String ns : this.properties.namespaces()) {
            endpoints.addAll(((EndpointsList)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)this.getClient().endpoints().inNamespace(ns)).withField("metadata.name", serviceId)).withLabels(this.properties.serviceLabels())).list()).getItems());
        }
        return endpoints;
    }

    private List<ServiceInstance> getNamespaceServiceInstances(EndpointSubsetNS es, String serviceId) {
        String namespace = es.namespace();
        List<EndpointSubset> subsets = es.endpointSubset();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        if (!subsets.isEmpty()) {
            Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceId)).get();
            Map<String, String> serviceMetadata = this.getServiceMetadata(service);
            KubernetesDiscoveryProperties.Metadata metadataProps = this.properties.metadata();
            String primaryPortName = this.properties.primaryPortName();
            Map labels = service.getMetadata().getLabels();
            if (labels != null && labels.containsKey("primary-port-name")) {
                primaryPortName = (String)labels.get("primary-port-name");
            }
            for (EndpointSubset s : subsets) {
                HashMap<String, String> endpointMetadata = new HashMap<String, String>(serviceMetadata);
                if (metadataProps.addPorts()) {
                    Map<String, String> ports = s.getPorts().stream().filter(port -> StringUtils.hasText((String)port.getName())).collect(Collectors.toMap(EndpointPort::getName, port -> Integer.toString(port.getPort())));
                    Map<String, String> portMetadata = this.getMapWithPrefixedKeys(ports, metadataProps.portsPrefix());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding port metadata: " + portMetadata));
                    }
                    endpointMetadata.putAll(portMetadata);
                }
                if (this.properties.allNamespaces()) {
                    endpointMetadata.put("k8s_namespace", namespace);
                }
                ArrayList addresses = s.getAddresses();
                if (this.properties.includeNotReadyAddresses() && !CollectionUtils.isEmpty((Collection)s.getNotReadyAddresses())) {
                    if (addresses == null) {
                        addresses = new ArrayList();
                    }
                    addresses.addAll(s.getNotReadyAddresses());
                }
                for (EndpointAddress endpointAddress : addresses) {
                    int endpointPort = this.findEndpointPort(s, serviceId, primaryPortName);
                    String instanceId = null;
                    if (endpointAddress.getTargetRef() != null) {
                        instanceId = endpointAddress.getTargetRef().getUid();
                    }
                    instances.add((ServiceInstance)new DefaultKubernetesServiceInstance(instanceId, serviceId, endpointAddress.getIp(), endpointPort, endpointMetadata, this.servicePortSecureResolver.resolve(new ServicePortSecureResolver.Input(endpointPort, service.getMetadata().getName(), service.getMetadata().getLabels(), service.getMetadata().getAnnotations()))));
                }
            }
        }
        return instances;
    }

    private Map<String, String> getServiceMetadata(Service service) {
        HashMap<String, String> serviceMetadata = new HashMap<String, String>();
        KubernetesDiscoveryProperties.Metadata metadataProps = this.properties.metadata();
        if (metadataProps.addLabels()) {
            Map<String, String> labelMetadata = this.getMapWithPrefixedKeys(service.getMetadata().getLabels(), metadataProps.labelsPrefix());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding label metadata: " + labelMetadata));
            }
            serviceMetadata.putAll(labelMetadata);
        }
        if (metadataProps.addAnnotations()) {
            Map<String, String> annotationMetadata = this.getMapWithPrefixedKeys(service.getMetadata().getAnnotations(), metadataProps.annotationsPrefix());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding annotation metadata: " + annotationMetadata));
            }
            serviceMetadata.putAll(annotationMetadata);
        }
        return serviceMetadata;
    }

    private int findEndpointPort(EndpointSubset s, String serviceId, String primaryPortName) {
        List endpointPorts = s.getPorts();
        if (endpointPorts.size() == 1) {
            return ((EndpointPort)endpointPorts.get(0)).getPort();
        }
        Map<String, Integer> ports = endpointPorts.stream().filter(p -> StringUtils.hasText((String)p.getName())).collect(Collectors.toMap(EndpointPort::getName, EndpointPort::getPort));
        int discoveredPort = ports.getOrDefault(primaryPortName, ports.getOrDefault("https", ports.getOrDefault("http", -1)));
        if (discoveredPort == -1) {
            if (StringUtils.hasText((String)primaryPortName)) {
                log.warn((Object)("Could not find a port named '" + primaryPortName + "', 'https', or 'http' for service '" + serviceId + "'."));
            } else {
                log.warn((Object)("Could not find a port named 'https' or 'http' for service '" + serviceId + "'."));
            }
            log.warn((Object)"Make sure that either the primary-port-name label has been added to the service, or that spring.cloud.kubernetes.discovery.primary-port-name has been configured.");
            log.warn((Object)"Alternatively name the primary port 'https' or 'http'");
            log.warn((Object)"An incorrect configuration may result in non-deterministic behaviour.");
            discoveredPort = ((EndpointPort)endpointPorts.get(0)).getPort();
        }
        return discoveredPort;
    }

    private EndpointSubsetNS getSubsetsFromEndpoints(Endpoints endpoints) {
        EndpointSubsetNS es = new EndpointSubsetNS(this.client.getNamespace(), null);
        if (endpoints != null && endpoints.getSubsets() != null) {
            es = new EndpointSubsetNS(endpoints.getMetadata().getNamespace(), endpoints.getSubsets());
        }
        return es;
    }

    private Map<String, String> getMapWithPrefixedKeys(Map<String, String> map, String prefix) {
        if (map == null) {
            return new HashMap<String, String>();
        }
        if (!StringUtils.hasText((String)prefix)) {
            return map;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        map.forEach((k, v) -> result.put(prefix + k, (String)v));
        return result;
    }

    public List<String> getServices() {
        Predicate<Service> filteredServices;
        String spelExpression = this.properties.filter();
        if (spelExpression == null || spelExpression.isEmpty()) {
            filteredServices = instance -> true;
        } else {
            Expression filterExpr = this.parser.parseExpression(spelExpression);
            filteredServices = instance -> {
                Boolean include = (Boolean)filterExpr.getValue((EvaluationContext)this.evalCtxt, instance, Boolean.class);
                if (include == null) {
                    return false;
                }
                return include;
            };
        }
        return this.getServices(filteredServices);
    }

    public List<String> getServices(Predicate<Service> filter) {
        if (this.properties.namespaces().isEmpty()) {
            return ((ServiceList)((FilterWatchListDeletable)this.kubernetesClientServicesFunction.apply(this.client)).list()).getItems().stream().filter(filter).map(s -> s.getMetadata().getName()).collect(Collectors.toList());
        }
        ArrayList<String> services = new ArrayList<String>();
        for (String ns : this.properties.namespaces()) {
            services.addAll(((ServiceList)((NonNamespaceOperation)this.getClient().services().inNamespace(ns)).list()).getItems().stream().filter(filter).map(s -> s.getMetadata().getName()).toList());
        }
        return services;
    }

    public int getOrder() {
        return this.properties.order();
    }
}

