/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.fabric8.discovery.EndpointSubsetNS;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunction;
import org.springframework.cloud.kubernetes.fabric8.discovery.ServicePortSecureResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KubernetesDiscoveryClient
implements DiscoveryClient {
    private static final Log log = LogFactory.getLog(KubernetesDiscoveryClient.class);
    private static final String PRIMARY_PORT_NAME_LABEL_KEY = "primary-port-name";
    private static final String HTTPS_PORT_NAME = "https";
    private static final String HTTP_PORT_NAME = "http";
    private final KubernetesDiscoveryProperties properties;
    private final ServicePortSecureResolver servicePortSecureResolver;
    private final KubernetesClientServicesFunction kubernetesClientServicesFunction;
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final SimpleEvaluationContext evalCtxt = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    private KubernetesClient client;

    public KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction) {
        this(client, kubernetesDiscoveryProperties, kubernetesClientServicesFunction, new ServicePortSecureResolver(kubernetesDiscoveryProperties));
    }

    KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction, ServicePortSecureResolver servicePortSecureResolver) {
        this.client = client;
        this.properties = kubernetesDiscoveryProperties;
        this.kubernetesClientServicesFunction = kubernetesClientServicesFunction;
        this.servicePortSecureResolver = servicePortSecureResolver;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public String description() {
        return "Kubernetes Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Assert.notNull((Object)serviceId, (String)"[Assertion failed] - the object argument must not be null");
        List subsetsNS = this.getEndPointsList(serviceId).stream().map(this::getSubsetsFromEndpoints).collect(Collectors.toList());
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        if (!subsetsNS.isEmpty()) {
            for (EndpointSubsetNS es : subsetsNS) {
                instances.addAll(this.getNamespaceServiceInstances(es, serviceId));
            }
        }
        return instances;
    }

    public List<Endpoints> getEndPointsList(String serviceId) {
        List endpoints;
        List list = endpoints = this.properties.isAllNamespaces() ? ((EndpointsList)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListMultiDeletable)this.client.endpoints().inAnyNamespace()).withField("metadata.name", serviceId)).withLabels(this.properties.getServiceLabels())).list()).getItems() : ((EndpointsList)((FilterWatchListDeletable)((FilterWatchListDeletable)this.client.endpoints().withField("metadata.name", serviceId)).withLabels(this.properties.getServiceLabels())).list()).getItems();
        if (this.properties.getFilter() == null || this.properties.getFilter().isEmpty()) {
            return endpoints;
        }
        ArrayList<Endpoints> result = new ArrayList<Endpoints>();
        Map<String, List<Endpoints>> byNamespace = endpoints.stream().collect(Collectors.groupingBy(x -> x.getMetadata().getNamespace()));
        for (Map.Entry<String, List<Endpoints>> entry : byNamespace.entrySet()) {
            Set withFilter = ((ServiceList)((NonNamespaceOperation)this.client.services().inNamespace(entry.getKey())).list()).getItems().stream().filter(this.filter()).map(service -> service.getMetadata().getName()).collect(Collectors.toSet());
            result.addAll(entry.getValue().stream().filter(x -> withFilter.contains(x.getMetadata().getName())).collect(Collectors.toList()));
        }
        return result;
    }

    private List<ServiceInstance> getNamespaceServiceInstances(EndpointSubsetNS es, String serviceId) {
        String namespace = es.getNamespace();
        List<EndpointSubset> subsets = es.getEndpointSubset();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        if (!subsets.isEmpty()) {
            Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceId)).get();
            Map<String, String> serviceMetadata = this.getServiceMetadata(service);
            KubernetesDiscoveryProperties.Metadata metadataProps = this.properties.getMetadata();
            String primaryPortName = this.properties.getPrimaryPortName();
            Map labels = service.getMetadata().getLabels();
            if (labels != null && labels.containsKey(PRIMARY_PORT_NAME_LABEL_KEY)) {
                primaryPortName = (String)labels.get(PRIMARY_PORT_NAME_LABEL_KEY);
            }
            for (EndpointSubset s : subsets) {
                HashMap<String, String> endpointMetadata = new HashMap<String, String>(serviceMetadata);
                if (metadataProps.isAddPorts()) {
                    Map<String, String> ports = s.getPorts().stream().filter(port -> StringUtils.hasText((String)port.getName())).collect(Collectors.toMap(EndpointPort::getName, port -> Integer.toString(port.getPort())));
                    Map<String, String> portMetadata = this.getMapWithPrefixedKeys(ports, metadataProps.getPortsPrefix());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding port metadata: " + portMetadata));
                    }
                    endpointMetadata.putAll(portMetadata);
                }
                if (this.properties.isAllNamespaces()) {
                    endpointMetadata.put("k8s_namespace", namespace);
                }
                ArrayList addresses = s.getAddresses();
                if (this.properties.isIncludeNotReadyAddresses() && !CollectionUtils.isEmpty((Collection)s.getNotReadyAddresses())) {
                    if (addresses == null) {
                        addresses = new ArrayList();
                    }
                    addresses.addAll(s.getNotReadyAddresses());
                }
                for (EndpointAddress endpointAddress : addresses) {
                    int endpointPort = this.findEndpointPort(s, serviceId, primaryPortName);
                    String instanceId = null;
                    if (endpointAddress.getTargetRef() != null) {
                        instanceId = endpointAddress.getTargetRef().getUid();
                    }
                    instances.add((ServiceInstance)new KubernetesServiceInstance(instanceId, serviceId, endpointAddress.getIp(), endpointPort, endpointMetadata, Boolean.valueOf(this.servicePortSecureResolver.resolve(new ServicePortSecureResolver.Input(endpointPort, service.getMetadata().getName(), service.getMetadata().getLabels(), service.getMetadata().getAnnotations())))));
                }
            }
        }
        return instances;
    }

    private Map<String, String> getServiceMetadata(Service service) {
        HashMap<String, String> serviceMetadata = new HashMap<String, String>();
        KubernetesDiscoveryProperties.Metadata metadataProps = this.properties.getMetadata();
        if (metadataProps.isAddLabels()) {
            Map<String, String> labelMetadata = this.getMapWithPrefixedKeys(service.getMetadata().getLabels(), metadataProps.getLabelsPrefix());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding label metadata: " + labelMetadata));
            }
            serviceMetadata.putAll(labelMetadata);
        }
        if (metadataProps.isAddAnnotations()) {
            Map<String, String> annotationMetadata = this.getMapWithPrefixedKeys(service.getMetadata().getAnnotations(), metadataProps.getAnnotationsPrefix());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding annotation metadata: " + annotationMetadata));
            }
            serviceMetadata.putAll(annotationMetadata);
        }
        return serviceMetadata;
    }

    private int findEndpointPort(EndpointSubset s, String serviceId, String primaryPortName) {
        List endpointPorts = s.getPorts();
        if (endpointPorts.size() == 0) {
            log.debug((Object)("no ports found for service : " + serviceId + ", will return zero"));
            return 0;
        }
        if (endpointPorts.size() == 1) {
            return ((EndpointPort)endpointPorts.get(0)).getPort();
        }
        Map<String, Integer> ports = endpointPorts.stream().filter(p -> StringUtils.hasText((String)p.getName())).collect(Collectors.toMap(EndpointPort::getName, EndpointPort::getPort));
        int discoveredPort = ports.getOrDefault(primaryPortName, ports.getOrDefault(HTTPS_PORT_NAME, ports.getOrDefault(HTTP_PORT_NAME, -1)));
        if (discoveredPort == -1) {
            if (StringUtils.hasText((String)primaryPortName)) {
                log.warn((Object)("Could not find a port named '" + primaryPortName + "', 'https', or 'http' for service '" + serviceId + "'."));
            } else {
                log.warn((Object)("Could not find a port named 'https' or 'http' for service '" + serviceId + "'."));
            }
            log.warn((Object)"Make sure that either the primary-port-name label has been added to the service, or that spring.cloud.kubernetes.discovery.primary-port-name has been configured.");
            log.warn((Object)"Alternatively name the primary port 'https' or 'http'");
            log.warn((Object)"An incorrect configuration may result in non-deterministic behaviour.");
            discoveredPort = ((EndpointPort)endpointPorts.get(0)).getPort();
        }
        return discoveredPort;
    }

    private EndpointSubsetNS getSubsetsFromEndpoints(Endpoints endpoints) {
        EndpointSubsetNS es = new EndpointSubsetNS();
        es.setNamespace(this.client.getNamespace());
        if (endpoints != null && endpoints.getSubsets() != null) {
            es.setNamespace(endpoints.getMetadata().getNamespace());
            es.setEndpointSubset(endpoints.getSubsets());
        }
        return es;
    }

    private Map<String, String> getMapWithPrefixedKeys(Map<String, String> map, String prefix) {
        if (map == null) {
            return new HashMap<String, String>();
        }
        if (!StringUtils.hasText((String)prefix)) {
            return map;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        map.forEach((k, v) -> result.put(prefix + k, (String)v));
        return result;
    }

    public List<String> getServices() {
        return this.getServices(this.filter());
    }

    private Predicate<Service> filter() {
        Predicate<Service> filteredServices;
        String spelExpression = this.properties.getFilter();
        if (spelExpression == null || spelExpression.isEmpty()) {
            filteredServices = instance -> true;
        } else {
            Expression filterExpr = this.parser.parseExpression(spelExpression);
            filteredServices = instance -> {
                Boolean include = (Boolean)filterExpr.getValue((EvaluationContext)this.evalCtxt, instance, Boolean.class);
                if (include == null) {
                    return false;
                }
                return include;
            };
        }
        return filteredServices;
    }

    public List<String> getServices(Predicate<Service> filter) {
        return ((ServiceList)((FilterWatchListDeletable)this.kubernetesClientServicesFunction.apply(this.client)).list()).getItems().stream().filter(filter).map(s -> s.getMetadata().getName()).distinct().collect(Collectors.toList());
    }

    public int getOrder() {
        return this.properties.getOrder();
    }
}

