/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.ReadType;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigContext;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SourcesBatchRead;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=0)
public class Fabric8ConfigMapPropertySourceLocator
extends ConfigMapPropertySourceLocator {
    private final KubernetesClient client;
    private final KubernetesNamespaceProvider provider;

    Fabric8ConfigMapPropertySourceLocator(KubernetesClient client, ConfigMapConfigProperties properties, KubernetesNamespaceProvider provider) {
        super(properties);
        this.client = client;
        this.provider = provider;
    }

    public PropertySource<?> locate(Environment environment) {
        PropertySource configMapSources = super.locate(environment);
        Fabric8SourcesBatchRead.discardConfigMaps();
        return configMapSources;
    }

    protected MapPropertySource getPropertySource(ConfigurableEnvironment environment, NormalizedSource normalizedSource, ReadType readType) {
        String namespace = Fabric8Utils.getApplicationNamespace((KubernetesClient)this.client, (String)normalizedSource.namespace().orElse(null), (String)normalizedSource.target(), (KubernetesNamespaceProvider)this.provider);
        Fabric8ConfigContext context = new Fabric8ConfigContext(this.client, normalizedSource, namespace, (Environment)environment, readType);
        return new Fabric8ConfigMapPropertySource(context);
    }
}

