/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.ReadType;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SourcesBatchRead;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SourcesSingleRead;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;

public final class Fabric8ConfigUtils {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8ConfigUtils.class));

    private Fabric8ConfigUtils() {
    }

    public static Set<String> namespaces(KubernetesClient client, KubernetesNamespaceProvider provider, ConfigReloadProperties properties, String target) {
        Set<String> namespaces = properties.namespaces();
        if (namespaces.isEmpty()) {
            namespaces = Set.of(Fabric8Utils.getApplicationNamespace((KubernetesClient)client, null, (String)target, (KubernetesNamespaceProvider)provider));
        }
        LOG.debug((CharSequence)("informer namespaces : " + String.valueOf(namespaces)));
        return namespaces;
    }

    static MultipleSourcesContainer configMapsByName(KubernetesClient client, String namespace, LinkedHashSet<String> sourceNames, Environment environment, ReadType readType) {
        List<StrippedSourceContainer> strippedConfigMaps;
        if (readType.equals((Object)ReadType.BATCH)) {
            LOG.debug(() -> "Will read all configmaps in namespace : " + namespace);
            strippedConfigMaps = Fabric8SourcesBatchRead.strippedConfigMaps(client, namespace);
        } else {
            LOG.debug(() -> "Will read individual configmaps in namespace : " + namespace + " with names : " + String.valueOf(sourceNames));
            strippedConfigMaps = Fabric8SourcesSingleRead.strippedConfigMaps(client, namespace, sourceNames);
        }
        return ConfigUtils.processNamedData(strippedConfigMaps, (Environment)environment, sourceNames, (String)namespace, (boolean)false, (boolean)true);
    }

    static MultipleSourcesContainer secretsByName(KubernetesClient client, String namespace, LinkedHashSet<String> sourceNames, Environment environment, ReadType readType) {
        List<StrippedSourceContainer> strippedSecrets;
        if (readType.equals((Object)ReadType.BATCH)) {
            LOG.debug(() -> "Will read all secrets in namespace : " + namespace);
            strippedSecrets = Fabric8SourcesBatchRead.strippedSecrets(client, namespace);
        } else {
            LOG.debug(() -> "Will read individual secrets in namespace : " + namespace + " with names : " + String.valueOf(sourceNames));
            strippedSecrets = Fabric8SourcesSingleRead.strippedSecrets(client, namespace, sourceNames);
        }
        return ConfigUtils.processNamedData(strippedSecrets, (Environment)environment, sourceNames, (String)namespace, (boolean)true, (boolean)true);
    }

    static MultipleSourcesContainer configMapsByLabels(KubernetesClient client, String namespace, Map<String, String> labels, Environment environment, ReadType readType) {
        List<StrippedSourceContainer> strippedConfigMaps;
        if (readType.equals((Object)ReadType.BATCH)) {
            LOG.debug(() -> "Will read all configmaps in namespace : " + namespace);
            strippedConfigMaps = Fabric8SourcesBatchRead.strippedConfigMaps(client, namespace);
        } else {
            LOG.debug(() -> "Will read individual configmaps in namespace : " + namespace + " with labels : " + String.valueOf(labels));
            strippedConfigMaps = Fabric8SourcesSingleRead.strippedConfigMaps(client, namespace, labels);
        }
        return ConfigUtils.processLabeledData(strippedConfigMaps, (Environment)environment, labels, (String)namespace, (boolean)false);
    }

    static MultipleSourcesContainer secretsByLabels(KubernetesClient client, String namespace, Map<String, String> labels, Environment environment, ReadType readType) {
        List<StrippedSourceContainer> strippedSecrets;
        if (readType.equals((Object)ReadType.BATCH)) {
            LOG.debug(() -> "Will read all secrets in namespace : " + namespace);
            strippedSecrets = Fabric8SourcesBatchRead.strippedSecrets(client, namespace);
        } else {
            LOG.debug(() -> "Will read individual secrets in namespace : " + namespace + " with labels : " + String.valueOf(labels));
            strippedSecrets = Fabric8SourcesSingleRead.strippedSecrets(client, namespace, labels);
        }
        return ConfigUtils.processLabeledData(strippedSecrets, (Environment)environment, labels, (String)namespace, (boolean)true);
    }

    static List<StrippedSourceContainer> stripConfigMaps(List<ConfigMap> configMaps) {
        return configMaps.stream().map(configMap -> new StrippedSourceContainer(configMap.getMetadata().getLabels(), configMap.getMetadata().getName(), configMap.getData())).toList();
    }

    static List<StrippedSourceContainer> stripSecrets(List<Secret> secrets) {
        return secrets.stream().map(secret -> new StrippedSourceContainer(secret.getMetadata().getLabels(), secret.getMetadata().getName(), secret.getData())).toList();
    }
}

