/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;

final class Fabric8SourcesBatchRead {
    private static final ConcurrentHashMap<String, List<StrippedSourceContainer>> SECRETS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<StrippedSourceContainer>> CONFIGMAPS_CACHE = new ConcurrentHashMap();

    private Fabric8SourcesBatchRead() {
    }

    static void discardSecrets() {
        SECRETS_CACHE.clear();
    }

    static void discardConfigMaps() {
        CONFIGMAPS_CACHE.clear();
    }

    static List<StrippedSourceContainer> strippedConfigMaps(KubernetesClient client, String namespace) {
        return CONFIGMAPS_CACHE.computeIfAbsent(namespace, x -> Fabric8ConfigUtils.stripConfigMaps(((ConfigMapList)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).list()).getItems()));
    }

    static List<StrippedSourceContainer> strippedSecrets(KubernetesClient client, String namespace) {
        return SECRETS_CACHE.computeIfAbsent(namespace, x -> Fabric8ConfigUtils.stripSecrets(((SecretList)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).list()).getItems()));
    }
}

