/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapsCache;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsCache;
import org.springframework.core.env.Environment;

public final class Fabric8ConfigUtils {
    private static final Log LOG = LogFactory.getLog(Fabric8ConfigUtils.class);

    private Fabric8ConfigUtils() {
    }

    public static Set<String> namespaces(KubernetesClient client, KubernetesNamespaceProvider provider, ConfigReloadProperties properties, String target) {
        Set<String> namespaces = properties.namespaces();
        if (namespaces.isEmpty()) {
            namespaces = Set.of(Fabric8Utils.getApplicationNamespace((KubernetesClient)client, null, (String)target, (KubernetesNamespaceProvider)provider));
        }
        LOG.debug((Object)("informer namespaces : " + namespaces));
        return namespaces;
    }

    static MultipleSourcesContainer secretsDataByLabels(KubernetesClient client, String namespace, Map<String, String> labels, Environment environment) {
        List<StrippedSourceContainer> strippedSecrets = Fabric8ConfigUtils.strippedSecrets(client, namespace);
        if (strippedSecrets.isEmpty()) {
            return MultipleSourcesContainer.empty();
        }
        return ConfigUtils.processLabeledData(strippedSecrets, (Environment)environment, labels, (String)namespace, (boolean)true);
    }

    static MultipleSourcesContainer configMapsDataByLabels(KubernetesClient client, String namespace, Map<String, String> labels, Environment environment) {
        List<StrippedSourceContainer> strippedConfigMaps = Fabric8ConfigUtils.strippedConfigMaps(client, namespace);
        if (strippedConfigMaps.isEmpty()) {
            return MultipleSourcesContainer.empty();
        }
        return ConfigUtils.processLabeledData(strippedConfigMaps, (Environment)environment, labels, (String)namespace, (boolean)false);
    }

    static MultipleSourcesContainer secretsDataByName(KubernetesClient client, String namespace, LinkedHashSet<String> sourceNames, Environment environment) {
        List<StrippedSourceContainer> strippedSecrets = Fabric8ConfigUtils.strippedSecrets(client, namespace);
        if (strippedSecrets.isEmpty()) {
            return MultipleSourcesContainer.empty();
        }
        return ConfigUtils.processNamedData(strippedSecrets, (Environment)environment, sourceNames, (String)namespace, (boolean)true, (boolean)true);
    }

    static MultipleSourcesContainer configMapsDataByName(KubernetesClient client, String namespace, LinkedHashSet<String> sourceNames, Environment environment) {
        List<StrippedSourceContainer> strippedConfigMaps = Fabric8ConfigUtils.strippedConfigMaps(client, namespace);
        if (strippedConfigMaps.isEmpty()) {
            return MultipleSourcesContainer.empty();
        }
        return ConfigUtils.processNamedData(strippedConfigMaps, (Environment)environment, sourceNames, (String)namespace, (boolean)false, (boolean)true);
    }

    private static List<StrippedSourceContainer> strippedConfigMaps(KubernetesClient client, String namespace) {
        List<StrippedSourceContainer> strippedConfigMaps = Fabric8ConfigMapsCache.byNamespace(client, namespace);
        if (strippedConfigMaps.isEmpty()) {
            LOG.debug((Object)("No configmaps in namespace '" + namespace + "'"));
        }
        return strippedConfigMaps;
    }

    private static List<StrippedSourceContainer> strippedSecrets(KubernetesClient client, String namespace) {
        List<StrippedSourceContainer> strippedSecrets = Fabric8SecretsCache.byNamespace(client, namespace);
        if (strippedSecrets.isEmpty()) {
            LOG.debug((Object)("No secrets in namespace '" + namespace + "'"));
        }
        return strippedSecrets;
    }
}

