/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapCache;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.core.log.LogAccessor;

final class Fabric8ConfigMapsCache
implements ConfigMapCache {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8ConfigMapsCache.class));
    private static final ConcurrentHashMap<String, List<StrippedSourceContainer>> CACHE = new ConcurrentHashMap();

    Fabric8ConfigMapsCache() {
    }

    public void discardAll() {
        CACHE.clear();
    }

    static List<StrippedSourceContainer> byNamespace(KubernetesClient client, String namespace) {
        boolean[] b = new boolean[1];
        List result = CACHE.computeIfAbsent(namespace, x -> {
            b[0] = true;
            return Fabric8ConfigMapsCache.strippedConfigMaps(((ConfigMapList)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).list()).getItems());
        });
        if (b[0]) {
            LOG.debug(() -> "Loaded all config maps in namespace '" + namespace + "'");
        } else {
            LOG.debug(() -> "Loaded (from cache) all config maps in namespace '" + namespace + "'");
        }
        return result;
    }

    private static List<StrippedSourceContainer> strippedConfigMaps(List<ConfigMap> configMaps) {
        return configMaps.stream().map(configMap -> new StrippedSourceContainer(configMap.getMetadata().getLabels(), configMap.getMetadata().getName(), configMap.getData())).collect(Collectors.toList());
    }
}

