/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config.reload;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.commons.util.TaskSchedulerWrapper;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesAndConfigEnabled;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.commons.config.reload.PollingConfigMapChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.PollingSecretsChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.ConditionalOnKubernetesReloadEnabled;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.EventReloadDetectionMode;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.PollingReloadDetectionMode;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.reload.Fabric8EventBasedConfigMapChangeDetector;
import org.springframework.cloud.kubernetes.fabric8.config.reload.Fabric8EventBasedSecretsChangeDetector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.TaskScheduler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesAndConfigEnabled
@ConditionalOnKubernetesReloadEnabled
@ConditionalOnClass(value={EndpointAutoConfiguration.class, RestartEndpoint.class, ContextRefresher.class})
@AutoConfigureAfter(value={InfoEndpointAutoConfiguration.class, RefreshEndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={ConfigReloadProperties.class})
@Import(value={ConfigReloadAutoConfiguration.class})
public class Fabric8ConfigReloadAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={Fabric8ConfigMapPropertySourceLocator.class})
    @Conditional(value={PollingReloadDetectionMode.class})
    public ConfigurationChangeDetector configMapPropertyChangePollingWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator, TaskSchedulerWrapper<TaskScheduler> taskSchedulerWrapper, AbstractEnvironment environment) {
        return new PollingConfigMapChangeDetector(environment, properties, strategy, Fabric8ConfigMapPropertySource.class, (PropertySourceLocator)fabric8ConfigMapPropertySourceLocator, taskSchedulerWrapper.getTaskScheduler());
    }

    @Bean
    @ConditionalOnBean(value={Fabric8SecretsPropertySourceLocator.class})
    @Conditional(value={PollingReloadDetectionMode.class})
    public ConfigurationChangeDetector secretsPropertyChangePollingWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator, TaskSchedulerWrapper<TaskScheduler> taskScheduler, AbstractEnvironment environment) {
        return new PollingSecretsChangeDetector(environment, properties, strategy, Fabric8SecretsPropertySource.class, (PropertySourceLocator)fabric8SecretsPropertySourceLocator, taskScheduler.getTaskScheduler());
    }

    @Bean
    @ConditionalOnBean(value={Fabric8ConfigMapPropertySourceLocator.class})
    @Conditional(value={EventReloadDetectionMode.class})
    public ConfigurationChangeDetector configMapPropertyChangeEventWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator, AbstractEnvironment environment, KubernetesClient kubernetesClient) {
        return new Fabric8EventBasedConfigMapChangeDetector(environment, properties, kubernetesClient, strategy, fabric8ConfigMapPropertySourceLocator, new KubernetesNamespaceProvider((Environment)environment));
    }

    @Bean
    @ConditionalOnBean(value={Fabric8SecretsPropertySourceLocator.class})
    @Conditional(value={EventReloadDetectionMode.class})
    public ConfigurationChangeDetector secretsPropertyChangeEventWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator, AbstractEnvironment environment, KubernetesClient kubernetesClient) {
        return new Fabric8EventBasedSecretsChangeDetector(environment, properties, kubernetesClient, strategy, fabric8SecretsPropertySourceLocator, new KubernetesNamespaceProvider((Environment)environment));
    }
}

