/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config.reload;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class EventBasedSecretsChangeDetector
extends ConfigurationChangeDetector {
    private Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator;
    private Map<String, Watch> watches;
    private KubernetesClient kubernetesClient;

    public EventBasedSecretsChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator) {
        super((ConfigurableEnvironment)environment, properties, strategy);
        this.kubernetesClient = kubernetesClient;
        this.fabric8SecretsPropertySourceLocator = fabric8SecretsPropertySourceLocator;
        this.watches = new HashMap<String, Watch>();
    }

    @PreDestroy
    public void shutdown() {
        this.kubernetesClient.close();
    }

    @PostConstruct
    public void watch() {
        boolean activated = false;
        if (this.properties.isMonitoringSecrets()) {
            try {
                activated = false;
                final String name = "secrets-watch-event";
                this.watches.put(name, this.kubernetesClient.secrets().watch((Object)new Watcher<Secret>(){

                    public void eventReceived(Watcher.Action action, Secret secret) {
                        if (EventBasedSecretsChangeDetector.this.log.isDebugEnabled()) {
                            EventBasedSecretsChangeDetector.this.log.debug((Object)(name + " received event for Secret " + secret.getMetadata().getName()));
                        }
                        EventBasedSecretsChangeDetector.this.onEvent(secret);
                    }

                    public void onClose(WatcherException exception) {
                        EventBasedSecretsChangeDetector.this.log.debug((Object)"Secrects watch closed", (Throwable)exception);
                        Optional.ofNullable(exception).map(e -> {
                            EventBasedSecretsChangeDetector.this.log.debug((Object)"Exception received during watch", (Throwable)e);
                            return exception.asClientException();
                        }).map(KubernetesClientException::getStatus).map(Status::getCode).filter(c -> c.equals(410)).ifPresent(c -> EventBasedSecretsChangeDetector.this.watch());
                    }
                }));
                activated = true;
                this.log.info((Object)("Added new Kubernetes watch: " + name));
            }
            catch (Exception e) {
                this.log.error((Object)"Error while establishing a connection to watch secrets: configuration may remain stale", (Throwable)e);
            }
        }
        if (activated) {
            this.log.info((Object)"Kubernetes event-based secrets change detector activated");
        }
    }

    @PreDestroy
    public void unwatch() {
        if (this.watches != null) {
            for (Map.Entry<String, Watch> entry : this.watches.entrySet()) {
                try {
                    this.log.debug((Object)("Closing the watch " + entry.getKey()));
                    entry.getValue().close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error while closing the watch connection", (Throwable)e);
                }
            }
        }
    }

    protected void onEvent(Secret secret) {
        this.log.debug((Object)String.format("onEvent configMap: %s", secret.toString()));
        boolean changed = this.changed(this.locateMapPropertySources((PropertySourceLocator)this.fabric8SecretsPropertySourceLocator, (Environment)this.environment), this.findPropertySources(Fabric8SecretsPropertySource.class));
        if (changed) {
            this.log.info((Object)"Detected change in secrets");
            this.reloadProperties();
        }
    }
}

