/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;

public class Fabric8SecretsPropertySource
extends SecretsPropertySource {
    private static final Log LOG = LogFactory.getLog(Fabric8SecretsPropertySource.class);

    public Fabric8SecretsPropertySource(KubernetesClient client, String name, String namespace, Map<String, String> labels, boolean failFast) {
        super(Fabric8SecretsPropertySource.getSourceName((String)name, (String)Fabric8ConfigUtils.getApplicationNamespace(client, namespace, "Secret", null)), Fabric8SecretsPropertySource.getSourceData(client, name, Fabric8ConfigUtils.getApplicationNamespace(client, namespace, "Secret", null), labels, failFast));
    }

    private static Map<String, Object> getSourceData(KubernetesClient client, String name, String namespace, Map<String, String> labels, boolean failFast) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LOG.debug((Object)("Loading Secret with name '" + name + "' or with labels [" + labels + "] in namespace '" + namespace + "'"));
        try {
            Secret secret = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(name)).get();
            if (secret == null) {
                LOG.warn((Object)("secret with name : " + name + " in namespace : " + namespace + " not found"));
            } else {
                Fabric8SecretsPropertySource.putDataFromSecret(secret, result, namespace);
            }
            if (labels != null && !labels.isEmpty()) {
                ((SecretList)((FilterWatchListDeletable)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withLabels(labels)).list()).getItems().forEach(s -> Fabric8SecretsPropertySource.putDataFromSecret(s, result, namespace));
            }
        }
        catch (Exception e) {
            if (failFast) {
                throw new IllegalStateException("Unable to read Secret with name '" + name + "' or labels [" + labels + "] in namespace '" + namespace + "'", e);
            }
            LOG.warn((Object)("Can't read secret with name: [" + name + "] or labels [" + labels + "] in namespace: [" + namespace + "] (cause: " + e.getMessage() + "). Ignoring"));
        }
        return result;
    }

    private static void putDataFromSecret(Secret secret, Map<String, Object> result, String namespace) {
        LOG.debug((Object)("reading secret with name : " + secret.getMetadata().getName() + " in namespace : " + namespace));
        Fabric8SecretsPropertySource.putAll((Map)secret.getData(), result);
    }
}

