/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config.reload;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.commons.util.TaskSchedulerWrapper;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesAndConfigEnabled;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.commons.config.reload.PollingConfigMapChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.PollingSecretsChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.EventReloadDetectionMode;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.PollingReloadDetectionMode;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.reload.EventBasedConfigMapChangeDetector;
import org.springframework.cloud.kubernetes.fabric8.config.reload.EventBasedSecretsChangeDetector;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesAndConfigEnabled
@ConditionalOnClass(value={EndpointAutoConfiguration.class})
@AutoConfigureAfter(value={InfoEndpointAutoConfiguration.class, RefreshEndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={ConfigReloadProperties.class})
public class ConfigReloadAutoConfiguration {

    @ConditionalOnProperty(value={"spring.cloud.kubernetes.reload.enabled"})
    @ConditionalOnClass(value={RestartEndpoint.class, ContextRefresher.class})
    protected static class ConfigReloadAutoConfigurationBeans {
        @Autowired
        private AbstractEnvironment environment;
        @Autowired
        private KubernetesClient kubernetesClient;

        protected ConfigReloadAutoConfigurationBeans() {
        }

        @Bean
        @ConditionalOnBean(value={Fabric8ConfigMapPropertySourceLocator.class})
        @Conditional(value={PollingReloadDetectionMode.class})
        public ConfigurationChangeDetector configMapPropertyChangePollingWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator, TaskSchedulerWrapper taskSchedulerWrapper) {
            return new PollingConfigMapChangeDetector(this.environment, properties, strategy, Fabric8ConfigMapPropertySource.class, (PropertySourceLocator)fabric8ConfigMapPropertySourceLocator, taskSchedulerWrapper.getTaskScheduler());
        }

        @Bean
        @ConditionalOnBean(value={Fabric8SecretsPropertySourceLocator.class})
        @Conditional(value={PollingReloadDetectionMode.class})
        public ConfigurationChangeDetector secretsPropertyChangePollingWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator, TaskSchedulerWrapper taskScheduler) {
            return new PollingSecretsChangeDetector(this.environment, properties, strategy, Fabric8SecretsPropertySource.class, (PropertySourceLocator)fabric8SecretsPropertySourceLocator, taskScheduler.getTaskScheduler());
        }

        @Bean
        @ConditionalOnBean(value={Fabric8ConfigMapPropertySourceLocator.class})
        @Conditional(value={EventReloadDetectionMode.class})
        public ConfigurationChangeDetector configMapPropertyChangeEventWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator) {
            return new EventBasedConfigMapChangeDetector(this.environment, properties, this.kubernetesClient, strategy, fabric8ConfigMapPropertySourceLocator);
        }

        @Bean
        @ConditionalOnBean(value={Fabric8SecretsPropertySourceLocator.class})
        @Conditional(value={EventReloadDetectionMode.class})
        public ConfigurationChangeDetector secretsPropertyChangeEventWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator) {
            return new EventBasedSecretsChangeDetector(this.environment, properties, this.kubernetesClient, strategy, fabric8SecretsPropertySourceLocator);
        }

        @Bean
        @ConditionalOnMissingBean
        public ConfigurationUpdateStrategy configurationUpdateStrategy(ConfigReloadProperties properties, ConfigurableApplicationContext ctx, @Autowired(required=false) RestartEndpoint restarter, ContextRefresher refresher) {
            switch (properties.getStrategy()) {
                case RESTART_CONTEXT: {
                    Assert.notNull((Object)restarter, (String)"Restart endpoint is not enabled");
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> {
                        ConfigReloadAutoConfigurationBeans.wait(properties);
                        restarter.restart();
                    });
                }
                case REFRESH: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> ((ContextRefresher)refresher).refresh());
                }
                case SHUTDOWN: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> {
                        ConfigReloadAutoConfigurationBeans.wait(properties);
                        ctx.close();
                    });
                }
            }
            throw new IllegalStateException("Unsupported configuration update strategy: " + properties.getStrategy());
        }

        private static void wait(ConfigReloadProperties properties) {
            long waitMillis = ThreadLocalRandom.current().nextLong(properties.getMaxWaitForRestart().toMillis());
            try {
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

