/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.NamespaceResolutionFailedException;
import org.springframework.util.StringUtils;

public final class Fabric8ConfigUtils {
    private static final Log LOG = LogFactory.getLog(Fabric8ConfigUtils.class);

    private Fabric8ConfigUtils() {
    }

    @Deprecated
    public static String getApplicationNamespace(KubernetesClient client, String namespace, String configurationTarget) {
        if (!StringUtils.hasLength((String)namespace)) {
            LOG.debug((Object)(configurationTarget + " namespace has not been set, taking it from client (ns=" + client.getNamespace() + ")"));
            namespace = client.getNamespace();
        }
        return namespace;
    }

    @Deprecated
    public static String getApplicationNamespace(KubernetesClient client, String namespace) {
        return !StringUtils.hasLength((String)namespace) ? client.getNamespace() : namespace;
    }

    static String getApplicationNamespace(KubernetesClient client, String namespace, String configurationTarget, KubernetesNamespaceProvider provider) {
        String providerNamespace;
        if (StringUtils.hasText((String)namespace)) {
            LOG.debug((Object)(configurationTarget + " namespace from normalized source or passed directly : " + namespace));
            return namespace;
        }
        if (provider != null && StringUtils.hasText((String)(providerNamespace = provider.getNamespace()))) {
            LOG.debug((Object)(configurationTarget + " namespace from provider : " + namespace));
            return providerNamespace;
        }
        String clientNamespace = client.getNamespace();
        LOG.debug((Object)(configurationTarget + " namespace from client : " + clientNamespace));
        if (clientNamespace == null) {
            throw new NamespaceResolutionFailedException("unresolved namespace");
        }
        return clientNamespace;
    }

    static Map<String, String> getConfigMapData(KubernetesClient client, String namespace, String name) {
        ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name)).get();
        if (configMap == null) {
            LOG.info((Object)("config-map with name : '" + name + "' not present in namespace : '" + namespace + "'"));
            return Collections.emptyMap();
        }
        return configMap.getData();
    }
}

