/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySource;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class Fabric8ConfigMapPropertySource
extends ConfigMapPropertySource {
    private static final Log LOG = LogFactory.getLog(Fabric8ConfigMapPropertySource.class);

    public Fabric8ConfigMapPropertySource(KubernetesClient client, String name) {
        this(client, name, null, null);
    }

    public Fabric8ConfigMapPropertySource(KubernetesClient client, String name, String namespace, Environment environment) {
        super(Fabric8ConfigMapPropertySource.getName((String)name, (String)Fabric8ConfigMapPropertySource.getNamespace(client, namespace)), Fabric8ConfigMapPropertySource.asObjectMap(Fabric8ConfigMapPropertySource.getData(client, name, Fabric8ConfigMapPropertySource.getNamespace(client, namespace), environment)));
    }

    private static String getNamespace(KubernetesClient client, String namespace) {
        return StringUtils.isEmpty((Object)namespace) ? client.getNamespace() : namespace;
    }

    private static Map<String, Object> getData(KubernetesClient client, String name, String namespace, Environment environment) {
        try {
            ConfigMap map;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            ConfigMap configMap = map = StringUtils.isEmpty((Object)namespace) ? (ConfigMap)((Resource)client.configMaps().withName(name)).get() : (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name)).get();
            if (map != null) {
                result.putAll(Fabric8ConfigMapPropertySource.processAllEntries((Map)map.getData(), (Environment)environment));
            }
            if (environment != null) {
                for (String activeProfile : environment.getActiveProfiles()) {
                    ConfigMap mapWithProfile;
                    String mapNameWithProfile = name + "-" + activeProfile;
                    ConfigMap configMap2 = mapWithProfile = StringUtils.isEmpty((Object)namespace) ? (ConfigMap)((Resource)client.configMaps().withName(mapNameWithProfile)).get() : (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(mapNameWithProfile)).get();
                    if (mapWithProfile == null) continue;
                    result.putAll(Fabric8ConfigMapPropertySource.processAllEntries((Map)mapWithProfile.getData(), (Environment)environment));
                }
            }
            return result;
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't read configMap with name: [" + name + "] in namespace:[" + namespace + "]. Ignoring."), (Throwable)e);
            return new LinkedHashMap<String, Object>();
        }
    }
}

