/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.time.Duration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.Fabric8PodUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@AutoConfigureAfter(value={KubernetesCommonsAutoConfiguration.class})
public final class Fabric8AutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Config.class})
    public Config kubernetesClientConfig(KubernetesClientProperties kubernetesClientProperties) {
        Config base = Config.autoConfigure(null);
        ConfigBuilder builder = (ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(base).withMasterUrl(Fabric8AutoConfiguration.or(kubernetesClientProperties.masterUrl(), base.getMasterUrl()))).withApiVersion(Fabric8AutoConfiguration.or(kubernetesClientProperties.apiVersion(), base.getApiVersion()))).withNamespace(Fabric8AutoConfiguration.or(kubernetesClientProperties.namespace(), base.getNamespace()))).withUsername(Fabric8AutoConfiguration.or(kubernetesClientProperties.username(), base.getUsername()))).withPassword(Fabric8AutoConfiguration.or(kubernetesClientProperties.password(), base.getPassword()))).withOauthToken(Fabric8AutoConfiguration.or(kubernetesClientProperties.oauthToken(), base.getOauthToken()))).withCaCertFile(Fabric8AutoConfiguration.or(kubernetesClientProperties.caCertFile(), base.getCaCertFile()))).withCaCertData(Fabric8AutoConfiguration.or(kubernetesClientProperties.caCertData(), base.getCaCertData()))).withClientKeyFile(Fabric8AutoConfiguration.or(kubernetesClientProperties.clientKeyFile(), base.getClientKeyFile()))).withClientKeyData(Fabric8AutoConfiguration.or(kubernetesClientProperties.clientKeyData(), base.getClientKeyData()))).withClientCertFile(Fabric8AutoConfiguration.or(kubernetesClientProperties.clientCertFile(), base.getClientCertFile()))).withClientCertData(Fabric8AutoConfiguration.or(kubernetesClientProperties.clientCertData(), base.getClientCertData()))).withClientKeyAlgo(Fabric8AutoConfiguration.or(kubernetesClientProperties.clientKeyAlgo(), base.getClientKeyAlgo()))).withClientKeyPassphrase(Fabric8AutoConfiguration.or(kubernetesClientProperties.clientKeyPassphrase(), base.getClientKeyPassphrase()))).withConnectionTimeout(Fabric8AutoConfiguration.orDurationInt(kubernetesClientProperties.connectionTimeout(), base.getConnectionTimeout()))).withRequestTimeout(Fabric8AutoConfiguration.orDurationInt(kubernetesClientProperties.requestTimeout(), base.getRequestTimeout()))).withTrustCerts(Fabric8AutoConfiguration.or(kubernetesClientProperties.trustCerts(), base.isTrustCerts()))).withHttpProxy(Fabric8AutoConfiguration.or(kubernetesClientProperties.httpProxy(), base.getHttpProxy()))).withHttpsProxy(Fabric8AutoConfiguration.or(kubernetesClientProperties.httpsProxy(), base.getHttpsProxy()))).withProxyUsername(Fabric8AutoConfiguration.or(kubernetesClientProperties.proxyUsername(), base.getProxyUsername()))).withProxyPassword(Fabric8AutoConfiguration.or(kubernetesClientProperties.proxyPassword(), base.getProxyPassword()))).withNoProxy(Fabric8AutoConfiguration.or(kubernetesClientProperties.noProxy(), base.getNoProxy()))).withRequestRetryBackoffLimit(0);
        String userAgent = Fabric8AutoConfiguration.or(base.getUserAgent(), "Spring-Cloud-Kubernetes-Application");
        if (!kubernetesClientProperties.userAgent().equals("Spring-Cloud-Kubernetes-Application")) {
            userAgent = kubernetesClientProperties.userAgent();
        }
        return ((ConfigBuilder)builder.withUserAgent(userAgent)).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClient kubernetesClient(Config config) {
        return new KubernetesClientBuilder().withConfig(config).build();
    }

    @Bean
    @ConditionalOnMissingBean
    Fabric8PodUtils kubernetesPodUtils(KubernetesClient client) {
        return new Fabric8PodUtils(client);
    }

    private static <D> D or(D left, D right) {
        return left != null ? left : right;
    }

    private static Integer orDurationInt(Duration left, Integer right) {
        return left != null ? (int)left.toMillis() : right;
    }
}

