/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discoveryserver;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnHttpDiscoveryCatalogWatcherEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnKubernetesCatalogEnabled;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnKubernetesCatalogEnabled
@ConditionalOnHttpDiscoveryCatalogWatcherEnabled
class HeartBeatListener
implements ApplicationListener<HeartbeatEvent> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(HeartBeatListener.class));
    private final AtomicReference<List<EndpointNameAndNamespace>> lastState = new AtomicReference(List.of());

    HeartBeatListener(Environment environment) {
        String watchDelay = environment.getProperty("spring.cloud.kubernetes.discovery.catalogServicesWatchDelay");
        if (watchDelay != null) {
            LOG.debug((CharSequence)("using delay : " + watchDelay));
        } else {
            LOG.debug((CharSequence)"using default watch delay : 30000");
        }
    }

    public void onApplicationEvent(HeartbeatEvent event) {
        LOG.debug(() -> "received heartbeat event");
        List state = (List)event.getValue();
        LOG.debug(() -> "state received : " + String.valueOf(state));
        this.lastState.set(state);
    }

    AtomicReference<List<EndpointNameAndNamespace>> lastState() {
        return this.lastState;
    }
}

