/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerBootstrapper;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClientBlockingAutoConfiguration;

class ConfigServerBootstrapper
extends KubernetesConfigServerBootstrapper {
    ConfigServerBootstrapper() {
    }

    public void initialize(BootstrapRegistry registry) {
        if (ConfigServerBootstrapper.hasConfigServerInstanceProvider()) {
            return;
        }
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, KubernetesFunction::create);
    }

    static final class KubernetesFunction
    implements ConfigServerInstanceProvider.Function {
        private KubernetesFunction() {
        }

        static KubernetesFunction create(BootstrapContext context) {
            return new KubernetesFunction();
        }

        public List<ServiceInstance> apply(String serviceId, Binder binder, BindHandler bindHandler, Log log) {
            if (binder == null || bindHandler == null || !KubernetesConfigServerBootstrapper.getDiscoveryEnabled((Binder)binder, (BindHandler)bindHandler).booleanValue()) {
                return Collections.emptyList();
            }
            return this.getInstanceProvider(binder, bindHandler).getInstances(serviceId);
        }

        private KubernetesConfigServerInstanceProvider getInstanceProvider(Binder binder, BindHandler bindHandler) {
            KubernetesDiscoveryProperties kubernetesDiscoveryProperties = (KubernetesDiscoveryProperties)binder.bind("spring.cloud.kubernetes.discovery", Bindable.of(KubernetesDiscoveryProperties.class), bindHandler).orElseGet(() -> KubernetesDiscoveryProperties.DEFAULT);
            KubernetesDiscoveryClientBlockingAutoConfiguration autoConfiguration = new KubernetesDiscoveryClientBlockingAutoConfiguration();
            KubernetesDiscoveryClient discoveryClient = autoConfiguration.kubernetesDiscoveryClient(autoConfiguration.restTemplateBuilder(), kubernetesDiscoveryProperties);
            return arg_0 -> ((DiscoveryClient)discoveryClient).getInstances(arg_0);
        }

        public List<ServiceInstance> apply(String serviceId) {
            return this.apply(serviceId, null, null, null);
        }
    }
}

