/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesServiceInstance;
import org.springframework.util.Assert;

public class KubernetesDiscoveryClient
implements DiscoveryClient {
    private static final Log log = LogFactory.getLog(KubernetesDiscoveryClient.class);
    private static final String HOSTNAME = "HOSTNAME";
    private KubernetesClient client;
    private KubernetesDiscoveryProperties properties;

    public KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties) {
        this.client = client;
        this.properties = this.properties;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public String description() {
        return "Kubernetes Discovery Client";
    }

    public ServiceInstance getLocalServiceInstance() {
        String serviceName = this.properties.getServiceName();
        String podName = System.getenv(HOSTNAME);
        DefaultServiceInstance defaultInstance = new DefaultServiceInstance(serviceName, "localhost", 8080, false);
        Endpoints endpoints = (Endpoints)((Resource)this.client.endpoints().withName(serviceName)).get();
        Optional<Object> service = Optional.ofNullable(((Resource)this.client.services().withName(serviceName)).get());
        Map labels = service.isPresent() ? ((Service)service.get()).getMetadata().getLabels() : null;
        if (Utils.isNullOrEmpty((String)podName) || endpoints == null) {
            return defaultInstance;
        }
        try {
            List subsets = endpoints.getSubsets();
            if (subsets != null) {
                for (EndpointSubset s : subsets) {
                    List addresses = s.getAddresses();
                    Iterator iterator = addresses.iterator();
                    if (!iterator.hasNext()) continue;
                    EndpointAddress a = (EndpointAddress)iterator.next();
                    return new KubernetesServiceInstance(serviceName, a, (EndpointPort)s.getPorts().stream().findFirst().orElseThrow(IllegalStateException::new), labels, false);
                }
            }
            return defaultInstance;
        }
        catch (Throwable t) {
            return defaultInstance;
        }
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Assert.notNull((Object)serviceId, (String)"[Assertion failed] - the object argument must be null");
        Optional<Object> service = Optional.ofNullable(((Resource)this.client.services().withName(serviceId)).get());
        Map labels = service.isPresent() ? ((Service)service.get()).getMetadata().getLabels() : null;
        Optional<Object> endpoints = Optional.ofNullable(((Resource)this.client.endpoints().withName(serviceId)).get());
        List subsets = ((Endpoints)endpoints.get()).getSubsets();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        if (subsets != null) {
            for (EndpointSubset s : subsets) {
                List addresses = s.getAddresses();
                for (EndpointAddress a : addresses) {
                    instances.add(new KubernetesServiceInstance(serviceId, a, (EndpointPort)s.getPorts().stream().findFirst().orElseThrow(IllegalStateException::new), labels, false));
                }
            }
        }
        return instances;
    }

    public List<String> getServices() {
        return ((ServiceList)this.client.services().list()).getItems().stream().map(s -> s.getMetadata().getName()).collect(Collectors.toList());
    }
}

