/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.boot.actuate.autoconfigure.amqp.RabbitHealthContributorAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.function.context.config.ContextFunctionCatalogAutoConfiguration;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.configuration.watcher.BusEventBasedConfigMapWatcherChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.BusEventBasedSecretsWatcherChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.BusRefreshTrigger;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigMapWatcherChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.configuration.watcher.RefreshTriggerAutoConfiguration;
import org.springframework.cloud.kubernetes.configuration.watcher.SecretsWatcherChangeDetector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@Profile(value={"bus-amqp"})
@Import(value={ContextFunctionCatalogAutoConfiguration.class, RabbitHealthContributorAutoConfiguration.class})
@AutoConfigureAfter(value={RefreshTriggerAutoConfiguration.class})
class BusRabbitAutoConfiguration {
    BusRabbitAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={KubernetesClientConfigMapPropertySourceLocator.class})
    ConfigMapWatcherChangeDetector busConfigMapChangeWatcher(AbstractEnvironment environment, CoreV1Api coreV1Api, KubernetesClientConfigMapPropertySourceLocator configMapPropertySourceLocator, KubernetesNamespaceProvider kubernetesNamespaceProvider, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadFactory, BusRefreshTrigger busRefreshTrigger) {
        return new BusEventBasedConfigMapWatcherChangeDetector(coreV1Api, (ConfigurableEnvironment)environment, properties, strategy, configMapPropertySourceLocator, kubernetesNamespaceProvider, k8SConfigurationProperties, threadFactory, busRefreshTrigger);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={KubernetesClientSecretsPropertySourceLocator.class})
    SecretsWatcherChangeDetector busSecretsChangeWatcher(AbstractEnvironment environment, CoreV1Api coreV1Api, KubernetesClientSecretsPropertySourceLocator secretsPropertySourceLocator, ConfigReloadProperties properties, KubernetesNamespaceProvider kubernetesNamespaceProvider, ConfigurationUpdateStrategy strategy, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadFactory, BusRefreshTrigger busRefreshTrigger) {
        return new BusEventBasedSecretsWatcherChangeDetector(coreV1Api, (ConfigurableEnvironment)environment, properties, strategy, secretsPropertySourceLocator, kubernetesNamespaceProvider, k8SConfigurationProperties, threadFactory, busRefreshTrigger);
    }
}

