/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.reload.KubernetesClientEventBasedConfigMapChangeDetector;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.configuration.watcher.RefreshTrigger;
import org.springframework.cloud.kubernetes.configuration.watcher.WatcherUtil;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ConfigMapWatcherChangeDetector
extends KubernetesClientEventBasedConfigMapChangeDetector
implements RefreshTrigger {
    private final ScheduledExecutorService executorService;
    private final long refreshDelay;

    ConfigMapWatcherChangeDetector(CoreV1Api coreV1Api, ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientConfigMapPropertySourceLocator propertySourceLocator, KubernetesNamespaceProvider kubernetesNamespaceProvider, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        super(coreV1Api, environment, properties, strategy, propertySourceLocator, kubernetesNamespaceProvider);
        this.executorService = Executors.newScheduledThreadPool(k8SConfigurationProperties.getThreadPoolSize(), (ThreadFactory)threadPoolTaskExecutor);
        this.refreshDelay = k8SConfigurationProperties.getRefreshDelay().toMillis();
    }

    protected final void onEvent(KubernetesObject configMap) {
        WatcherUtil.onEvent((KubernetesObject)configMap, (String)"spring.cloud.kubernetes.config", (String)"spring.cloud.kubernetes.configmap.apps", (long)this.refreshDelay, (ScheduledExecutorService)this.executorService, (String)"config-map", (arg_0, arg_1) -> ((ConfigMapWatcherChangeDetector)this).triggerRefresh(arg_0, arg_1));
    }
}

