/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.reload.EventBasedConfigMapChangeDetector;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import reactor.core.publisher.Mono;

public abstract class ConfigMapWatcherChangeDetector
extends EventBasedConfigMapChangeDetector {
    protected Log log = LogFactory.getLog(this.getClass());
    private ScheduledExecutorService executorService;
    protected ConfigurationWatcherConfigurationProperties k8SConfigurationProperties;

    public ConfigMapWatcherChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        super(environment, properties, kubernetesClient, strategy, fabric8ConfigMapPropertySourceLocator);
        this.executorService = Executors.newScheduledThreadPool(k8SConfigurationProperties.getThreadPoolSize(), (ThreadFactory)threadPoolTaskExecutor);
        this.k8SConfigurationProperties = k8SConfigurationProperties;
    }

    protected void onEvent(ConfigMap configMap) {
        if (this.isSpringCloudKubernetesConfig(configMap)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Scheduling remote refresh event to be published for ConfigMap " + configMap.getMetadata().getName() + " to be published in " + this.k8SConfigurationProperties.getRefreshDelay().toMillis() + " milliseconds"));
            }
            this.executorService.schedule(() -> {
                try {
                    this.triggerRefresh(configMap).subscribe();
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Error when refreshing ConfigMap " + configMap.getMetadata().getName()), t);
                }
            }, this.k8SConfigurationProperties.getRefreshDelay().toMillis(), TimeUnit.MILLISECONDS);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Not publishing event. ConfigMap " + configMap.getMetadata().getName() + " does not contain the label " + this.k8SConfigurationProperties.getConfigLabel()));
        }
    }

    protected boolean isSpringCloudKubernetesConfig(ConfigMap configMap) {
        if (configMap.getMetadata() == null || configMap.getMetadata().getLabels() == null) {
            return false;
        }
        return Boolean.parseBoolean(configMap.getMetadata().getLabels().getOrDefault(this.k8SConfigurationProperties.getConfigLabel(), "false"));
    }

    protected abstract Mono<Void> triggerRefresh(ConfigMap var1);
}

