/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.leader.election;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.springframework.cloud.kubernetes.commons.leader.election.CachedSingleThreadScheduler;
import org.springframework.core.log.LogAccessor;

public final class PodReadyRunner {
    private final String candidateIdentity;
    private final String candidateNamespace;
    private static final long TTL_MILLIS = 100L;
    private static final LogAccessor LOG = new LogAccessor(PodReadyRunner.class);
    private final CachedSingleThreadScheduler podReadySelfShutDownScheduler = new CachedSingleThreadScheduler("podReadyExecutor", 100L);

    public PodReadyRunner(String candidateIdentity, String candidateNamespace) {
        this.candidateIdentity = candidateIdentity;
        this.candidateNamespace = candidateNamespace;
    }

    public CompletableFuture<Void> podReady(BooleanSupplier podReadySupplier) {
        CompletableFuture<Void> podReadyCompletableFuture = new CompletableFuture<Void>();
        ScheduledFuture<?> scheduledFuture = this.podReadySelfShutDownScheduler.scheduleWithFixedDelay(() -> {
            if (podReadyCompletableFuture.isDone()) {
                LOG.info(() -> "podReadyCompletableFuture is done");
                return;
            }
            try {
                if (podReadySupplier.getAsBoolean()) {
                    LOG.info(() -> "Pod : " + this.candidateIdentity + " in namespace : " + this.candidateNamespace + " is ready");
                    podReadyCompletableFuture.complete(null);
                } else {
                    LOG.debug(() -> "Pod : " + this.candidateIdentity + " in namespace : " + this.candidateNamespace + " is not ready, will retry in one second");
                }
            }
            catch (Exception e) {
                LOG.error(() -> "exception waiting for pod : " + this.candidateIdentity);
                LOG.error(() -> "pod readiness for : " + this.candidateIdentity + " failed with : " + e.getMessage());
                podReadyCompletableFuture.completeExceptionally(e);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.attachShutDownHook(podReadyCompletableFuture, scheduledFuture);
        return podReadyCompletableFuture;
    }

    private void attachShutDownHook(CompletableFuture<Void> podReadyCompletableFuture, ScheduledFuture<?> scheduledFuture) {
        podReadyCompletableFuture.whenComplete((ok, nok) -> {
            if (nok != null) {
                if (podReadyCompletableFuture.isCancelled()) {
                    LOG.debug(() -> "canceling scheduled future because completable future was cancelled");
                } else {
                    LOG.debug(() -> "canceling scheduled future because readiness failed");
                }
            } else {
                LOG.debug(() -> "canceling scheduled future because readiness succeeded");
            }
            boolean canceled = scheduledFuture.cancel(true);
            LOG.info(() -> "scheduledFuture is canceled: " + canceled);
        });
    }
}

