/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.leader.election;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionProperties;
import org.springframework.core.log.LogAccessor;

public final class LeaderElectionInitiatorUtil {
    private static final LogAccessor LOG = new LogAccessor(LeaderElectionInitiatorUtil.class);

    private LeaderElectionInitiatorUtil() {
    }

    public static void blockReadinessCheck(CompletableFuture<?> ready) {
        try {
            ready.get();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, () -> "block readiness check failed with : " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static void shutDownExecutor(ExecutorService podReadyWaitingExecutor, String candidateIdentity) {
        LOG.debug(() -> "podReadyWaitingExecutor will be shutdown for : " + candidateIdentity);
        podReadyWaitingExecutor.shutdownNow();
        try {
            podReadyWaitingExecutor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static CompletableFuture<?> attachReadinessLoggerPipeline(CompletableFuture<?> innerPodReadyFuture, String candidateIdentity) {
        return innerPodReadyFuture.whenComplete((ok, error) -> {
            if (error != null) {
                LOG.error(() -> "readiness failed for : " + candidateIdentity + ", leader election will not start");
            } else {
                LOG.info(() -> candidateIdentity + " is ready");
            }
        });
    }

    public static void sleep(LeaderElectionProperties leaderElectionProperties) {
        try {
            TimeUnit.SECONDS.sleep(leaderElectionProperties.waitAfterRenewalFailure().toSeconds());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

