/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapCache;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.MountConfigMapPropertySource;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.PropertySourceUtils;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class ConfigMapPropertySourceLocator
implements PropertySourceLocator {
    private static final Log LOG = LogFactory.getLog(ConfigMapPropertySourceLocator.class);
    private final ConfigMapCache cache;
    protected final ConfigMapConfigProperties properties;

    public ConfigMapPropertySourceLocator(ConfigMapConfigProperties properties, ConfigMapCache cache) {
        this.properties = properties;
        this.cache = cache;
    }

    protected abstract MapPropertySource getMapPropertySource(NormalizedSource var1, ConfigurableEnvironment var2);

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            CompositePropertySource composite = new CompositePropertySource("composite-configmap");
            if (this.properties.enableApi()) {
                LinkedHashSet<NormalizedSource> sources = new LinkedHashSet<NormalizedSource>(this.properties.determineSources(environment));
                LOG.debug((Object)("Config Map normalized sources : " + sources));
                sources.forEach(s -> {
                    MapPropertySource propertySource = this.getMapPropertySource((NormalizedSource)s, env);
                    if ("true".equals(propertySource.getProperty("spring.cloud.k8s.error.reading.property.source"))) {
                        LOG.warn((Object)("Failed to load source: " + s));
                    } else {
                        LOG.debug((Object)("Adding config map property source " + propertySource.getName()));
                        composite.addFirstPropertySource((PropertySource)propertySource);
                    }
                });
            }
            this.addPropertySourcesFromPaths(environment, composite);
            this.cache.discardAll();
            return composite;
        }
        return null;
    }

    public Collection<PropertySource<?>> locateCollection(Environment environment) {
        return super.locateCollection(environment);
    }

    private void addPropertySourcesFromPaths(Environment environment, CompositePropertySource composite) {
        LinkedHashSet<String> uniquePaths = new LinkedHashSet<String>(this.properties.paths());
        if (!uniquePaths.isEmpty()) {
            LOG.warn((Object)"path support is deprecated and will be removed in a future release. Please use spring.config.import");
        }
        LOG.debug((Object)("paths property sources : " + uniquePaths));
        uniquePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(p -> {
            boolean exists = Files.exists(p, new LinkOption[0]);
            if (!exists) {
                LOG.warn((Object)("Configured input path: " + p + " will be ignored because it does not exist on the file system"));
            }
            return exists;
        }).filter(p -> {
            boolean regular = Files.isRegularFile(p, new LinkOption[0]);
            if (!regular) {
                LOG.warn((Object)("Configured input path: " + p + " will be ignored because it is not a regular file"));
            }
            return regular;
        }).toList().forEach(p -> {
            try {
                String content = new String(Files.readAllBytes(p)).trim();
                String filename = p.toAbsolutePath().toString().toLowerCase(Locale.ROOT);
                if (filename.endsWith(".properties")) {
                    this.addPropertySourceIfNeeded(c -> PropertySourceUtils.PROPERTIES_TO_MAP.apply(PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.apply((String)c)), content, filename, composite);
                } else if (filename.endsWith(".yml") || filename.endsWith(".yaml")) {
                    this.addPropertySourceIfNeeded(c -> PropertySourceUtils.yamlParserGenerator(environment).apply((String)c), content, filename, composite);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Error reading input file", (Throwable)e);
            }
        });
    }

    private void addPropertySourceIfNeeded(Function<String, Map<String, Object>> contentToMapFunction, String content, String name, CompositePropertySource composite) {
        HashMap<String, Object> map = new HashMap<String, Object>(contentToMapFunction.apply(content));
        if (map.isEmpty()) {
            LOG.warn((Object)("Property source: " + name + "will be ignored because no properties could be found"));
        } else {
            LOG.debug((Object)("will add file-based property source : " + name));
            composite.addFirstPropertySource((PropertySource)new MountConfigMapPropertySource(name, map));
        }
    }
}

