/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Collection;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.SecretsCache;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySource;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.retry.support.RetryTemplate;

public class ConfigDataRetryableSecretsPropertySourceLocator
extends SecretsPropertySourceLocator {
    private final RetryTemplate retryTemplate;
    private SecretsPropertySourceLocator secretsPropertySourceLocator;

    public ConfigDataRetryableSecretsPropertySourceLocator(SecretsPropertySourceLocator propertySourceLocator, SecretsConfigProperties secretsConfigProperties, SecretsCache cache) {
        super(secretsConfigProperties, cache);
        this.secretsPropertySourceLocator = propertySourceLocator;
        this.retryTemplate = RetryTemplate.builder().maxAttempts(this.properties.retry().maxAttempts()).exponentialBackoff(this.properties.retry().initialInterval(), this.properties.retry().multiplier(), this.properties.retry().maxInterval()).build();
    }

    @Override
    public PropertySource<?> locate(Environment environment) {
        return (PropertySource)this.retryTemplate.execute(retryContext -> this.secretsPropertySourceLocator.locate(environment));
    }

    @Override
    public Collection<PropertySource<?>> locateCollection(Environment environment) {
        return (Collection)this.retryTemplate.execute(retryContext -> this.secretsPropertySourceLocator.locateCollection(environment));
    }

    @Override
    protected SecretsPropertySource getPropertySource(ConfigurableEnvironment environment, NormalizedSource normalizedSource) {
        return this.secretsPropertySourceLocator.getPropertySource(environment, normalizedSource);
    }

    public SecretsPropertySourceLocator getSecretsPropertySourceLocator() {
        return this.secretsPropertySourceLocator;
    }

    public void setSecretsPropertySourceLocator(SecretsPropertySourceLocator secretsPropertySourceLocator) {
        this.secretsPropertySourceLocator = secretsPropertySourceLocator;
    }
}

