/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Collection;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapCache;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.retry.support.RetryTemplate;

public class ConfigDataRetryableConfigMapPropertySourceLocator
extends ConfigMapPropertySourceLocator {
    private final RetryTemplate retryTemplate;
    private ConfigMapPropertySourceLocator configMapPropertySourceLocator;

    public ConfigDataRetryableConfigMapPropertySourceLocator(ConfigMapPropertySourceLocator configMapPropertySourceLocator, ConfigMapConfigProperties properties, ConfigMapCache cache) {
        super(properties, cache);
        this.configMapPropertySourceLocator = configMapPropertySourceLocator;
        this.retryTemplate = RetryTemplate.builder().maxAttempts(properties.retry().maxAttempts()).exponentialBackoff(properties.retry().initialInterval(), properties.retry().multiplier(), properties.retry().maxInterval()).build();
    }

    @Override
    protected MapPropertySource getMapPropertySource(NormalizedSource normalizedSource, ConfigurableEnvironment environment) {
        return this.configMapPropertySourceLocator.getMapPropertySource(normalizedSource, environment);
    }

    @Override
    public PropertySource<?> locate(Environment environment) {
        return (PropertySource)this.retryTemplate.execute(retryContext -> this.configMapPropertySourceLocator.locate(environment));
    }

    @Override
    public Collection<PropertySource<?>> locateCollection(Environment environment) {
        return (Collection)this.retryTemplate.execute(retryContext -> this.configMapPropertySourceLocator.locateCollection(environment));
    }

    public void setConfigMapPropertySourceLocator(ConfigMapPropertySourceLocator configMapPropertySourceLocator) {
        this.configMapPropertySourceLocator = configMapPropertySourceLocator;
    }

    public ConfigMapPropertySourceLocator getConfigMapPropertySourceLocator() {
        return this.configMapPropertySourceLocator;
    }
}

