/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.cloud.kubernetes.commons.config.SourceDataFlattener;

public abstract class LabeledSourceData {
    private static final Log LOG = LogFactory.getLog(LabeledSourceData.class);

    public final SourceData compute(Map<String, String> labels, ConfigUtils.Prefix prefix, String target, boolean profileSources, boolean failFast, String namespace, String[] activeProfiles) {
        MultipleSourcesContainer data = MultipleSourcesContainer.empty();
        try {
            Set<String> profiles = Set.of();
            if (profileSources) {
                profiles = Arrays.stream(activeProfiles).collect(Collectors.toSet());
            }
            data = this.dataSupplier(labels, profiles);
            LinkedHashSet<String> sourceNames = data.names();
            Map<String, Object> sourceDataForSourceName = data.data();
            String sourceDataName = ConfigUtils.sourceDataName(target, sourceNames, namespace);
            if (sourceNames.isEmpty()) {
                return this.emptySourceData(labels, target, namespace);
            }
            if (prefix.getName().equals(ConfigUtils.Prefix.DEFAULT.getName())) {
                return new SourceData(sourceDataName, SourceDataFlattener.defaultFlattenedSourceData(sourceNames, sourceDataForSourceName));
            }
            if (prefix.getName().equals(ConfigUtils.Prefix.KNOWN.getName())) {
                return new SourceData(sourceDataName, SourceDataFlattener.prefixFlattenedSourceData(sourceNames, sourceDataForSourceName, prefix.prefixProvider().get()));
            }
            if (prefix.getName().equals(ConfigUtils.Prefix.DELAYED.getName())) {
                return new SourceData(sourceDataName, SourceDataFlattener.nameFlattenedSourceData(sourceNames, sourceDataForSourceName));
            }
            throw new IllegalArgumentException("Unsupported prefix: " + prefix);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failure in reading labeled sources");
            ConfigUtils.onException(failFast, e);
            return new SourceData(ConfigUtils.sourceDataName(target, data.names(), namespace), Map.of("spring.cloud.k8s.error.reading.property.source", "true"));
        }
    }

    private SourceData emptySourceData(Map<String, String> labels, String target, String namespace) {
        String sourceName = labels.keySet().stream().sorted().collect(Collectors.collectingAndThen(Collectors.joining("."), sortedLabels -> ConfigUtils.sourceName(target, sortedLabels, namespace)));
        return SourceData.emptyRecord(sourceName);
    }

    public abstract MultipleSourcesContainer dataSupplier(Map<String, String> var1, Set<String> var2);
}

