/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import jakarta.annotation.PostConstruct;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadUtil;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public class PollingConfigMapChangeDetector
extends ConfigurationChangeDetector {
    protected Log log = LogFactory.getLog(this.getClass());
    private final PropertySourceLocator propertySourceLocator;
    private final Class<? extends MapPropertySource> propertySourceClass;
    private final TaskScheduler taskExecutor;
    private final long period;
    private final boolean monitorConfigMaps;

    public PollingConfigMapChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Class<? extends MapPropertySource> propertySourceClass, PropertySourceLocator propertySourceLocator, TaskScheduler taskExecutor) {
        super((ConfigurableEnvironment)environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.propertySourceClass = propertySourceClass;
        this.taskExecutor = taskExecutor;
        this.period = properties.period().toMillis();
        this.monitorConfigMaps = properties.monitoringConfigMaps();
    }

    @PostConstruct
    private void init() {
        this.log.info((Object)"Kubernetes polling configMap change detector activated");
        PeriodicTrigger trigger = new PeriodicTrigger(Duration.ofMillis(this.period));
        trigger.setInitialDelay(Duration.ofMillis(this.period));
        this.taskExecutor.schedule(this::executeCycle, (Trigger)trigger);
    }

    private void executeCycle() {
        boolean changedConfigMap;
        if (this.monitorConfigMaps && (changedConfigMap = ConfigReloadUtil.reload(this.propertySourceLocator, this.environment, this.propertySourceClass))) {
            this.log.info((Object)"Detected change in config maps");
            this.reloadProperties();
        }
    }
}

